/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.Scheduler$Worker;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableBufferTimed$BufferExactBoundedSubscriber;
import io.reactivex.internal.operators.flowable.FlowableBufferTimed$BufferExactUnboundedSubscriber;
import io.reactivex.internal.operators.flowable.FlowableBufferTimed$BufferSkipBoundedSubscriber;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public final class FlowableBufferTimed<T, U extends Collection<? super T>>
extends AbstractFlowableWithUpstream<T, U> {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Callable<U> bufferSupplier;
    final int maxSize;
    final boolean restartTimerOnMaxSize;

    public FlowableBufferTimed(Flowable<T> source, long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, Callable<U> bufferSupplier, int maxSize, boolean restartTimerOnMaxSize) {
        super(source);
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSupplier = bufferSupplier;
        this.maxSize = maxSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
    }

    @Override
    public void subscribeActual(Yx<? super U> s2) {
        if (this.timespan == this.timeskip && this.maxSize == Integer.MAX_VALUE) {
            this.source.subscribe(new FlowableBufferTimed$BufferExactUnboundedSubscriber(new SerializedSubscriber<U>(s2), this.bufferSupplier, this.timespan, this.unit, this.scheduler));
            return;
        }
        Scheduler$Worker w2 = this.scheduler.createWorker();
        if (this.timespan == this.timeskip) {
            this.source.subscribe(new FlowableBufferTimed$BufferExactBoundedSubscriber(new SerializedSubscriber<U>(s2), this.bufferSupplier, this.timespan, this.unit, this.maxSize, this.restartTimerOnMaxSize, w2));
            return;
        }
        this.source.subscribe(new FlowableBufferTimed$BufferSkipBoundedSubscriber(new SerializedSubscriber<U>(s2), this.bufferSupplier, this.timespan, this.timeskip, this.unit, w2));
    }
}

