/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableBufferTimed$BufferSkipBoundedSubscriber$RemoveFromBuffer;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

final class FlowableBufferTimed$BufferSkipBoundedSubscriber<T, U extends Collection<? super T>>
extends QueueDrainSubscriber<T, U, U>
implements Yy,
Runnable {
    final Callable<U> bufferSupplier;
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler$Worker w;
    final List<U> buffers;
    Yy s;

    FlowableBufferTimed$BufferSkipBoundedSubscriber(Yx<? super U> actual, Callable<U> bufferSupplier, long timespan, long timeskip, TimeUnit unit, Scheduler$Worker w2) {
        super(actual, new MpscLinkedQueue());
        this.bufferSupplier = bufferSupplier;
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.w = w2;
        this.buffers = new LinkedList<U>();
    }

    @Override
    public void onSubscribe(Yy s2) {
        Collection b2;
        if (!SubscriptionHelper.validate(this.s, s2)) {
            return;
        }
        this.s = s2;
        try {
            b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.w.dispose();
            s2.cancel();
            EmptySubscription.error(e2, this.actual);
            return;
        }
        this.buffers.add(b2);
        this.actual.onSubscribe(this);
        s2.request(Long.MAX_VALUE);
        this.w.schedulePeriodically(this, this.timeskip, this.timeskip, this.unit);
        this.w.schedule(new FlowableBufferTimed$BufferSkipBoundedSubscriber$RemoveFromBuffer(this, b2), this.timespan, this.unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        FlowableBufferTimed$BufferSkipBoundedSubscriber flowableBufferTimed$BufferSkipBoundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferSkipBoundedSubscriber) {
            for (Collection b2 : this.buffers) {
                b2.add(t2);
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.done = true;
        this.w.dispose();
        this.clear();
        this.actual.onError(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        ArrayList<U> bs2;
        FlowableBufferTimed$BufferSkipBoundedSubscriber flowableBufferTimed$BufferSkipBoundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferSkipBoundedSubscriber) {
            bs2 = new ArrayList<U>(this.buffers);
            this.buffers.clear();
        }
        for (Collection b2 : bs2) {
            this.queue.offer(b2);
        }
        this.done = true;
        if (this.enter()) {
            QueueDrainHelper.drainMaxLoop(this.queue, this.actual, false, this.w, this);
        }
    }

    @Override
    public void request(long n2) {
        this.requested(n2);
    }

    @Override
    public void cancel() {
        this.clear();
        this.s.cancel();
        this.w.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        FlowableBufferTimed$BufferSkipBoundedSubscriber flowableBufferTimed$BufferSkipBoundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferSkipBoundedSubscriber) {
            this.buffers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Collection b2;
        if (this.cancelled) {
            return;
        }
        try {
            b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.cancel();
            this.actual.onError(e2);
            return;
        }
        FlowableBufferTimed$BufferSkipBoundedSubscriber flowableBufferTimed$BufferSkipBoundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferSkipBoundedSubscriber) {
            if (this.cancelled) {
                return;
            }
            this.buffers.add(b2);
        }
        this.w.schedule(new FlowableBufferTimed$BufferSkipBoundedSubscriber$RemoveFromBuffer(this, b2), this.timespan, this.unit);
    }

    @Override
    public boolean accept(Yx<? super U> a2, U v2) {
        a2.onNext(v2);
        return true;
    }

    static /* synthetic */ void access$000(FlowableBufferTimed$BufferSkipBoundedSubscriber x0, Object x1, boolean x2, Disposable x3) {
        x0.fastPathOrderedEmitMax(x1, x2, x3);
    }
}

