/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableBufferTimed$BufferExactUnboundedSubscriber<T, U extends Collection<? super T>>
extends QueueDrainSubscriber<T, U, U>
implements Yy,
Disposable,
Runnable {
    final Callable<U> bufferSupplier;
    final long timespan;
    final TimeUnit unit;
    final Scheduler scheduler;
    Yy s;
    U buffer;
    final AtomicReference<Disposable> timer = new AtomicReference();

    FlowableBufferTimed$BufferExactUnboundedSubscriber(Yx<? super U> actual, Callable<U> bufferSupplier, long timespan, TimeUnit unit, Scheduler scheduler) {
        super(actual, new MpscLinkedQueue());
        this.bufferSupplier = bufferSupplier;
        this.timespan = timespan;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            Collection b2;
            this.s = s2;
            try {
                b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.cancel();
                EmptySubscription.error(e2, this.actual);
                return;
            }
            this.buffer = b2;
            this.actual.onSubscribe(this);
            if (!this.cancelled) {
                s2.request(Long.MAX_VALUE);
                Disposable d2 = this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit);
                if (!this.timer.compareAndSet(null, d2)) {
                    d2.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        FlowableBufferTimed$BufferExactUnboundedSubscriber flowableBufferTimed$BufferExactUnboundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferExactUnboundedSubscriber) {
            U b2 = this.buffer;
            if (b2 != null) {
                b2.add(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t2) {
        DisposableHelper.dispose(this.timer);
        FlowableBufferTimed$BufferExactUnboundedSubscriber flowableBufferTimed$BufferExactUnboundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferExactUnboundedSubscriber) {
            this.buffer = null;
        }
        this.actual.onError(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        U b2;
        DisposableHelper.dispose(this.timer);
        FlowableBufferTimed$BufferExactUnboundedSubscriber flowableBufferTimed$BufferExactUnboundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferExactUnboundedSubscriber) {
            b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            this.buffer = null;
        }
        this.queue.offer(b2);
        this.done = true;
        if (this.enter()) {
            QueueDrainHelper.drainMaxLoop(this.queue, this.actual, false, null, this);
        }
    }

    @Override
    public void request(long n2) {
        this.requested(n2);
    }

    @Override
    public void cancel() {
        this.s.cancel();
        DisposableHelper.dispose(this.timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        U current;
        Collection next;
        try {
            next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.cancel();
            this.actual.onError(e2);
            return;
        }
        FlowableBufferTimed$BufferExactUnboundedSubscriber flowableBufferTimed$BufferExactUnboundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferExactUnboundedSubscriber) {
            current = this.buffer;
            if (current != null) {
                this.buffer = next;
            }
        }
        if (current == null) {
            DisposableHelper.dispose(this.timer);
            return;
        }
        this.fastPathEmitMax(current, false, this);
    }

    @Override
    public boolean accept(Yx<? super U> a2, U v2) {
        this.actual.onNext(v2);
        return true;
    }

    @Override
    public void dispose() {
        this.cancel();
    }

    @Override
    public boolean isDisposed() {
        return this.timer.get() == DisposableHelper.DISPOSED;
    }
}

