/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

final class FlowableBufferTimed$BufferExactBoundedSubscriber<T, U extends Collection<? super T>>
extends QueueDrainSubscriber<T, U, U>
implements Yy,
Disposable,
Runnable {
    final Callable<U> bufferSupplier;
    final long timespan;
    final TimeUnit unit;
    final int maxSize;
    final boolean restartTimerOnMaxSize;
    final Scheduler$Worker w;
    U buffer;
    Disposable timer;
    Yy s;
    long producerIndex;
    long consumerIndex;

    FlowableBufferTimed$BufferExactBoundedSubscriber(Yx<? super U> actual, Callable<U> bufferSupplier, long timespan, TimeUnit unit, int maxSize, boolean restartOnMaxSize, Scheduler$Worker w2) {
        super(actual, new MpscLinkedQueue());
        this.bufferSupplier = bufferSupplier;
        this.timespan = timespan;
        this.unit = unit;
        this.maxSize = maxSize;
        this.restartTimerOnMaxSize = restartOnMaxSize;
        this.w = w2;
    }

    @Override
    public void onSubscribe(Yy s2) {
        Collection b2;
        if (!SubscriptionHelper.validate(this.s, s2)) {
            return;
        }
        this.s = s2;
        try {
            b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.w.dispose();
            s2.cancel();
            EmptySubscription.error(e2, this.actual);
            return;
        }
        this.buffer = b2;
        this.actual.onSubscribe(this);
        this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
        s2.request(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        Object b2;
        FlowableBufferTimed$BufferExactBoundedSubscriber flowableBufferTimed$BufferExactBoundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferExactBoundedSubscriber) {
            b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            b2.add(t2);
            if (b2.size() < this.maxSize) {
                return;
            }
            this.buffer = null;
            ++this.producerIndex;
        }
        if (this.restartTimerOnMaxSize) {
            this.timer.dispose();
        }
        this.fastPathOrderedEmitMax(b2, false, this);
        try {
            b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.cancel();
            this.actual.onError(e2);
            return;
        }
        flowableBufferTimed$BufferExactBoundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferExactBoundedSubscriber) {
            this.buffer = b2;
            ++this.consumerIndex;
        }
        if (this.restartTimerOnMaxSize) {
            this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t2) {
        FlowableBufferTimed$BufferExactBoundedSubscriber flowableBufferTimed$BufferExactBoundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferExactBoundedSubscriber) {
            this.buffer = null;
        }
        this.actual.onError(t2);
        this.w.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        U b2;
        FlowableBufferTimed$BufferExactBoundedSubscriber flowableBufferTimed$BufferExactBoundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferExactBoundedSubscriber) {
            b2 = this.buffer;
            this.buffer = null;
        }
        this.queue.offer(b2);
        this.done = true;
        if (this.enter()) {
            QueueDrainHelper.drainMaxLoop(this.queue, this.actual, false, this, this);
        }
        this.w.dispose();
    }

    @Override
    public boolean accept(Yx<? super U> a2, U v2) {
        a2.onNext(v2);
        return true;
    }

    @Override
    public void request(long n2) {
        this.requested(n2);
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        FlowableBufferTimed$BufferExactBoundedSubscriber flowableBufferTimed$BufferExactBoundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferExactBoundedSubscriber) {
            this.buffer = null;
        }
        this.s.cancel();
        this.w.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.w.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        U current;
        Collection next;
        try {
            next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.cancel();
            this.actual.onError(e2);
            return;
        }
        FlowableBufferTimed$BufferExactBoundedSubscriber flowableBufferTimed$BufferExactBoundedSubscriber = this;
        synchronized (flowableBufferTimed$BufferExactBoundedSubscriber) {
            current = this.buffer;
            if (current == null || this.producerIndex != this.consumerIndex) {
                return;
            }
            this.buffer = next;
        }
        this.fastPathOrderedEmitMax(current, false, this);
    }
}

