/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableBufferExactBoundary$BufferBoundarySubscriber;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import java.util.Collection;
import java.util.concurrent.Callable;

final class FlowableBufferExactBoundary$BufferExactBoundarySubscriber<T, U extends Collection<? super T>, B>
extends QueueDrainSubscriber<T, U, U>
implements Yy,
FlowableSubscriber<T>,
Disposable {
    final Callable<U> bufferSupplier;
    final Yw<B> boundary;
    Yy s;
    Disposable other;
    U buffer;

    FlowableBufferExactBoundary$BufferExactBoundarySubscriber(Yx<? super U> actual, Callable<U> bufferSupplier, Yw<B> boundary) {
        super(actual, new MpscLinkedQueue());
        this.bufferSupplier = bufferSupplier;
        this.boundary = boundary;
    }

    @Override
    public void onSubscribe(Yy s2) {
        FlowableBufferExactBoundary$BufferBoundarySubscriber bs2;
        Collection b2;
        if (!SubscriptionHelper.validate(this.s, s2)) {
            return;
        }
        this.s = s2;
        try {
            b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.cancelled = true;
            s2.cancel();
            EmptySubscription.error(e2, this.actual);
            return;
        }
        this.buffer = b2;
        this.other = bs2 = new FlowableBufferExactBoundary$BufferBoundarySubscriber(this);
        this.actual.onSubscribe(this);
        if (!this.cancelled) {
            s2.request(Long.MAX_VALUE);
            this.boundary.subscribe(bs2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        FlowableBufferExactBoundary$BufferExactBoundarySubscriber flowableBufferExactBoundary$BufferExactBoundarySubscriber = this;
        synchronized (flowableBufferExactBoundary$BufferExactBoundarySubscriber) {
            U b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            b2.add(t2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.cancel();
        this.actual.onError(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        U b2;
        FlowableBufferExactBoundary$BufferExactBoundarySubscriber flowableBufferExactBoundary$BufferExactBoundarySubscriber = this;
        synchronized (flowableBufferExactBoundary$BufferExactBoundarySubscriber) {
            b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            this.buffer = null;
        }
        this.queue.offer(b2);
        this.done = true;
        if (this.enter()) {
            QueueDrainHelper.drainMaxLoop(this.queue, this.actual, false, this, this);
        }
    }

    @Override
    public void request(long n2) {
        this.requested(n2);
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.other.dispose();
            this.s.cancel();
            if (this.enter()) {
                this.queue.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void next() {
        U b2;
        Collection next;
        try {
            next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.cancel();
            this.actual.onError(e2);
            return;
        }
        FlowableBufferExactBoundary$BufferExactBoundarySubscriber flowableBufferExactBoundary$BufferExactBoundarySubscriber = this;
        synchronized (flowableBufferExactBoundary$BufferExactBoundarySubscriber) {
            b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            this.buffer = next;
        }
        this.fastPathEmitMax(b2, false, this);
    }

    @Override
    public void dispose() {
        this.cancel();
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    @Override
    public boolean accept(Yx<? super U> a2, U v2) {
        this.actual.onNext(v2);
        return true;
    }
}

