/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableBufferBoundary$BufferBoundarySubscriber$BufferOpenSubscriber;
import io.reactivex.internal.operators.flowable.FlowableBufferBoundary$BufferCloseSubscriber;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableBufferBoundary$BufferBoundarySubscriber<T, C extends Collection<? super T>, Open, Close>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = -8466418554264089604L;
    final Yx<? super C> actual;
    final Callable<C> bufferSupplier;
    final Yw<? extends Open> bufferOpen;
    final Function<? super Open, ? extends Yw<? extends Close>> bufferClose;
    final CompositeDisposable subscribers;
    final AtomicLong requested;
    final AtomicReference<Yy> upstream;
    final AtomicThrowable errors;
    volatile boolean done;
    final SpscLinkedArrayQueue<C> queue;
    volatile boolean cancelled;
    long index;
    Map<Long, C> buffers;
    long emitted;

    FlowableBufferBoundary$BufferBoundarySubscriber(Yx<? super C> actual, Yw<? extends Open> bufferOpen, Function<? super Open, ? extends Yw<? extends Close>> bufferClose, Callable<C> bufferSupplier) {
        this.actual = actual;
        this.bufferSupplier = bufferSupplier;
        this.bufferOpen = bufferOpen;
        this.bufferClose = bufferClose;
        this.queue = new SpscLinkedArrayQueue(Flowable.bufferSize());
        this.subscribers = new CompositeDisposable();
        this.requested = new AtomicLong();
        this.upstream = new AtomicReference();
        this.buffers = new LinkedHashMap<Long, C>();
        this.errors = new AtomicThrowable();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this.upstream, s2)) {
            FlowableBufferBoundary$BufferBoundarySubscriber$BufferOpenSubscriber open = new FlowableBufferBoundary$BufferBoundarySubscriber$BufferOpenSubscriber(this);
            this.subscribers.add(open);
            this.bufferOpen.subscribe(open);
            s2.request(Long.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        FlowableBufferBoundary$BufferBoundarySubscriber flowableBufferBoundary$BufferBoundarySubscriber = this;
        synchronized (flowableBufferBoundary$BufferBoundarySubscriber) {
            Map<Long, C> bufs = this.buffers;
            if (bufs == null) {
                return;
            }
            for (Collection b2 : bufs.values()) {
                b2.add(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t2) {
        if (this.errors.addThrowable(t2)) {
            this.subscribers.dispose();
            FlowableBufferBoundary$BufferBoundarySubscriber flowableBufferBoundary$BufferBoundarySubscriber = this;
            synchronized (flowableBufferBoundary$BufferBoundarySubscriber) {
                this.buffers = null;
            }
            this.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        this.subscribers.dispose();
        FlowableBufferBoundary$BufferBoundarySubscriber flowableBufferBoundary$BufferBoundarySubscriber = this;
        synchronized (flowableBufferBoundary$BufferBoundarySubscriber) {
            Map<Long, C> bufs = this.buffers;
            if (bufs == null) {
                return;
            }
            for (Collection b2 : bufs.values()) {
                this.queue.offer(b2);
            }
            this.buffers = null;
        }
        this.done = true;
        this.drain();
    }

    @Override
    public void request(long n2) {
        BackpressureHelper.add(this.requested, n2);
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        if (SubscriptionHelper.cancel(this.upstream)) {
            this.cancelled = true;
            this.subscribers.dispose();
            FlowableBufferBoundary$BufferBoundarySubscriber flowableBufferBoundary$BufferBoundarySubscriber = this;
            synchronized (flowableBufferBoundary$BufferBoundarySubscriber) {
                this.buffers = null;
            }
            if (this.getAndIncrement() != 0) {
                this.queue.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(Open token) {
        Yw<Close> p2;
        Collection buf;
        try {
            buf = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null Collection");
            p2 = ObjectHelper.requireNonNull(this.bufferClose.apply(token), "The bufferClose returned a null Publisher");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            SubscriptionHelper.cancel(this.upstream);
            this.onError(ex2);
            return;
        }
        long idx = this.index;
        this.index = idx + 1L;
        FlowableBufferBoundary$BufferBoundarySubscriber flowableBufferBoundary$BufferBoundarySubscriber = this;
        synchronized (flowableBufferBoundary$BufferBoundarySubscriber) {
            Map<Long, C> bufs = this.buffers;
            if (bufs == null) {
                return;
            }
            bufs.put(idx, buf);
        }
        FlowableBufferBoundary$BufferCloseSubscriber bc2 = new FlowableBufferBoundary$BufferCloseSubscriber(this, idx);
        this.subscribers.add(bc2);
        p2.subscribe(bc2);
    }

    void openComplete(FlowableBufferBoundary$BufferBoundarySubscriber$BufferOpenSubscriber<Open> os2) {
        this.subscribers.delete(os2);
        if (this.subscribers.size() == 0) {
            SubscriptionHelper.cancel(this.upstream);
            this.done = true;
            this.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(FlowableBufferBoundary$BufferCloseSubscriber<T, C> closer, long idx) {
        this.subscribers.delete(closer);
        boolean makeDone = false;
        if (this.subscribers.size() == 0) {
            makeDone = true;
            SubscriptionHelper.cancel(this.upstream);
        }
        FlowableBufferBoundary$BufferBoundarySubscriber flowableBufferBoundary$BufferBoundarySubscriber = this;
        synchronized (flowableBufferBoundary$BufferBoundarySubscriber) {
            Map<Long, C> bufs = this.buffers;
            if (bufs == null) {
                return;
            }
            this.queue.offer(this.buffers.remove(idx));
        }
        if (makeDone) {
            this.done = true;
        }
        this.drain();
    }

    void boundaryError(Disposable subscriber, Throwable ex2) {
        SubscriptionHelper.cancel(this.upstream);
        this.subscribers.delete(subscriber);
        this.onError(ex2);
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        long e2 = this.emitted;
        Yx<C> a2 = this.actual;
        SpscLinkedArrayQueue<C> q2 = this.queue;
        do {
            long r2 = this.requested.get();
            while (e2 != r2) {
                boolean empty;
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                boolean d2 = this.done;
                if (d2 && this.errors.get() != null) {
                    q2.clear();
                    Throwable ex2 = this.errors.terminate();
                    a2.onError(ex2);
                    return;
                }
                Collection v2 = (Collection)q2.poll();
                boolean bl2 = empty = v2 == null;
                if (d2 && empty) {
                    a2.onComplete();
                    return;
                }
                if (empty) break;
                a2.onNext(v2);
                ++e2;
            }
            if (e2 == r2) {
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                if (this.done) {
                    if (this.errors.get() != null) {
                        q2.clear();
                        Throwable ex3 = this.errors.terminate();
                        a2.onError(ex3);
                        return;
                    }
                    if (q2.isEmpty()) {
                        a2.onComplete();
                        return;
                    }
                }
            }
            this.emitted = e2;
        } while ((missed = this.addAndGet(-missed)) != 0);
    }
}

