/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableBuffer$PublisherBufferExactSubscriber;
import io.reactivex.internal.operators.flowable.FlowableBuffer$PublisherBufferOverlappingSubscriber;
import io.reactivex.internal.operators.flowable.FlowableBuffer$PublisherBufferSkipSubscriber;
import java.util.Collection;
import java.util.concurrent.Callable;

public final class FlowableBuffer<T, C extends Collection<? super T>>
extends AbstractFlowableWithUpstream<T, C> {
    final int size;
    final int skip;
    final Callable<C> bufferSupplier;

    public FlowableBuffer(Flowable<T> source, int size, int skip, Callable<C> bufferSupplier) {
        super(source);
        this.size = size;
        this.skip = skip;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    public void subscribeActual(Yx<? super C> s2) {
        if (this.size == this.skip) {
            this.source.subscribe(new FlowableBuffer$PublisherBufferExactSubscriber(s2, this.size, this.bufferSupplier));
        } else if (this.skip > this.size) {
            this.source.subscribe(new FlowableBuffer$PublisherBufferSkipSubscriber(s2, this.size, this.skip, this.bufferSupplier));
        } else {
            this.source.subscribe(new FlowableBuffer$PublisherBufferOverlappingSubscriber(s2, this.size, this.skip, this.bufferSupplier));
        }
    }
}

