/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

final class FlowableBuffer$PublisherBufferSkipSubscriber<T, C extends Collection<? super T>>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = -5616169793639412593L;
    final Yx<? super C> actual;
    final Callable<C> bufferSupplier;
    final int size;
    final int skip;
    C buffer;
    Yy s;
    boolean done;
    int index;

    FlowableBuffer$PublisherBufferSkipSubscriber(Yx<? super C> actual, int size, int skip, Callable<C> bufferSupplier) {
        this.actual = actual;
        this.size = size;
        this.skip = skip;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long u2 = BackpressureHelper.multiplyCap(n2, this.size);
                long v2 = BackpressureHelper.multiplyCap(this.skip - this.size, n2 - 1L);
                this.s.request(BackpressureHelper.addCap(u2, v2));
            } else {
                this.s.request(BackpressureHelper.multiplyCap(this.skip, n2));
            }
        }
    }

    @Override
    public void cancel() {
        this.s.cancel();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        Object b2 = this.buffer;
        int i2 = this.index;
        if (i2++ == 0) {
            try {
                b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null buffer");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.cancel();
                this.onError(e2);
                return;
            }
            this.buffer = b2;
        }
        if (b2 != null) {
            b2.add(t2);
            if (b2.size() == this.size) {
                this.buffer = null;
                this.actual.onNext(b2);
            }
        }
        if (i2 == this.skip) {
            i2 = 0;
        }
        this.index = i2;
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.buffer = null;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        C b2 = this.buffer;
        this.buffer = null;
        if (b2 != null) {
            this.actual.onNext(b2);
        }
        this.actual.onComplete();
    }
}

