/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BooleanSupplier;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableBuffer$PublisherBufferOverlappingSubscriber<T, C extends Collection<? super T>>
extends AtomicLong
implements Yy,
FlowableSubscriber<T>,
BooleanSupplier {
    private static final long serialVersionUID = -7370244972039324525L;
    final Yx<? super C> actual;
    final Callable<C> bufferSupplier;
    final int size;
    final int skip;
    final ArrayDeque<C> buffers;
    final AtomicBoolean once;
    Yy s;
    boolean done;
    int index;
    volatile boolean cancelled;
    long produced;

    FlowableBuffer$PublisherBufferOverlappingSubscriber(Yx<? super C> actual, int size, int skip, Callable<C> bufferSupplier) {
        this.actual = actual;
        this.size = size;
        this.skip = skip;
        this.bufferSupplier = bufferSupplier;
        this.once = new AtomicBoolean();
        this.buffers = new ArrayDeque();
    }

    @Override
    public boolean getAsBoolean() {
        return this.cancelled;
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            if (QueueDrainHelper.postCompleteRequest(n2, this.actual, this.buffers, this, this)) {
                return;
            }
            if (!this.once.get() && this.once.compareAndSet(false, true)) {
                long u2 = BackpressureHelper.multiplyCap(this.skip, n2 - 1L);
                long r2 = BackpressureHelper.addCap(this.size, u2);
                this.s.request(r2);
            } else {
                long r3 = BackpressureHelper.multiplyCap(this.skip, n2);
                this.s.request(r3);
            }
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.s.cancel();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        Collection b2;
        if (this.done) {
            return;
        }
        ArrayDeque<C> bs2 = this.buffers;
        int i2 = this.index;
        if (i2++ == 0) {
            try {
                b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null buffer");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.cancel();
                this.onError(e2);
                return;
            }
            bs2.offer(b2);
        }
        if ((b2 = (Collection)bs2.peek()) != null && b2.size() + 1 == this.size) {
            bs2.poll();
            b2.add(t2);
            ++this.produced;
            this.actual.onNext(b2);
        }
        for (Collection b0 : bs2) {
            b0.add(t2);
        }
        if (i2 == this.skip) {
            i2 = 0;
        }
        this.index = i2;
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.buffers.clear();
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        long p2 = this.produced;
        if (p2 != 0L) {
            BackpressureHelper.produced(this, p2);
        }
        QueueDrainHelper.postComplete(this.actual, this.buffers, this, this);
    }
}

