/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.concurrent.Callable;

final class FlowableBuffer$PublisherBufferExactSubscriber<T, C extends Collection<? super T>>
implements Yy,
FlowableSubscriber<T> {
    final Yx<? super C> actual;
    final Callable<C> bufferSupplier;
    final int size;
    C buffer;
    Yy s;
    boolean done;
    int index;

    FlowableBuffer$PublisherBufferExactSubscriber(Yx<? super C> actual, int size, Callable<C> bufferSupplier) {
        this.actual = actual;
        this.size = size;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            this.s.request(BackpressureHelper.multiplyCap(n2, this.size));
        }
    }

    @Override
    public void cancel() {
        this.s.cancel();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        Object b2 = this.buffer;
        if (b2 == null) {
            try {
                b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null buffer");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.cancel();
                this.onError(e2);
                return;
            }
            this.buffer = b2;
        }
        b2.add(t2);
        int i2 = this.index + 1;
        if (i2 == this.size) {
            this.index = 0;
            this.buffer = null;
            this.actual.onNext(b2);
        } else {
            this.index = i2;
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        C b2 = this.buffer;
        if (b2 != null && !b2.isEmpty()) {
            this.actual.onNext(b2);
        }
        this.actual.onComplete();
    }
}

