/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscribers.BlockingSubscriber;
import io.reactivex.internal.subscribers.LambdaSubscriber;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.internal.util.BlockingIgnoringReceiver;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.NotificationLite;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public final class FlowableBlockingSubscribe {
    private FlowableBlockingSubscribe() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> void subscribe(Yw<? extends T> o2, Yx<? super T> subscriber) {
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BlockingSubscriber bs2 = new BlockingSubscriber((Queue<Object>)queue);
        o2.subscribe(bs2);
        try {
            while (!bs2.isCancelled()) {
                Object v2 = queue.poll();
                if (v2 == null) {
                    if (bs2.isCancelled()) break;
                    BlockingHelper.verifyNonBlocking();
                    v2 = queue.take();
                }
                if (!bs2.isCancelled() && o2 != BlockingSubscriber.TERMINATED && !NotificationLite.acceptFull(v2, subscriber)) continue;
                break;
            }
        }
        catch (InterruptedException e2) {
            bs2.cancel();
            subscriber.onError(e2);
        }
    }

    public static <T> void subscribe(Yw<? extends T> o2) {
        BlockingIgnoringReceiver callback = new BlockingIgnoringReceiver();
        LambdaSubscriber ls2 = new LambdaSubscriber(Functions.emptyConsumer(), callback, callback, Functions.REQUEST_MAX);
        o2.subscribe(ls2);
        BlockingHelper.awaitForComplete(callback, ls2);
        Throwable e2 = callback.error;
        if (e2 != null) {
            throw ExceptionHelper.wrapOrThrow(e2);
        }
    }

    public static <T> void subscribe(Yw<? extends T> o2, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        ObjectHelper.requireNonNull(onNext, "onNext is null");
        ObjectHelper.requireNonNull(onError, "onError is null");
        ObjectHelper.requireNonNull(onComplete, "onComplete is null");
        FlowableBlockingSubscribe.subscribe(o2, new LambdaSubscriber<T>(onNext, onError, onComplete, Functions.REQUEST_MAX));
    }
}

