/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Notification;
import io.reactivex.internal.operators.flowable.BlockingFlowableNext$NextSubscriber;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class BlockingFlowableNext$NextIterator<T>
implements Iterator<T> {
    private final BlockingFlowableNext$NextSubscriber<T> observer;
    private final Yw<? extends T> items;
    private T next;
    private boolean hasNext = true;
    private boolean isNextConsumed = true;
    private Throwable error;
    private boolean started;

    BlockingFlowableNext$NextIterator(Yw<? extends T> items, BlockingFlowableNext$NextSubscriber<T> observer) {
        this.items = items;
        this.observer = observer;
    }

    @Override
    public boolean hasNext() {
        if (this.error != null) {
            throw ExceptionHelper.wrapOrThrow(this.error);
        }
        if (!this.hasNext) {
            return false;
        }
        return !this.isNextConsumed || this.moveToNext();
    }

    private boolean moveToNext() {
        try {
            Notification<T> nextNotification;
            if (!this.started) {
                this.started = true;
                this.observer.setWaiting();
                Flowable.fromPublisher(this.items).materialize().subscribe(this.observer);
            }
            if ((nextNotification = this.observer.takeNext()).isOnNext()) {
                this.isNextConsumed = false;
                this.next = nextNotification.getValue();
                return true;
            }
            this.hasNext = false;
            if (nextNotification.isOnComplete()) {
                return false;
            }
            if (nextNotification.isOnError()) {
                this.error = nextNotification.getError();
                throw ExceptionHelper.wrapOrThrow(this.error);
            }
            throw new IllegalStateException("Should not reach here");
        }
        catch (InterruptedException e2) {
            this.observer.dispose();
            this.error = e2;
            throw ExceptionHelper.wrapOrThrow(e2);
        }
    }

    @Override
    public T next() {
        if (this.error != null) {
            throw ExceptionHelper.wrapOrThrow(this.error);
        }
        if (this.hasNext()) {
            this.isNextConsumed = true;
            return this.next;
        }
        throw new NoSuchElementException("No more elements");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Read only iterator");
    }
}

