/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.completable.CompletableUsing$UsingObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class CompletableUsing<R>
extends Completable {
    final Callable<R> resourceSupplier;
    final Function<? super R, ? extends CompletableSource> completableFunction;
    final Consumer<? super R> disposer;
    final boolean eager;

    public CompletableUsing(Callable<R> resourceSupplier, Function<? super R, ? extends CompletableSource> completableFunction, Consumer<? super R> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.completableFunction = completableFunction;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        CompletableSource source;
        R resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            EmptyDisposable.error(ex2, observer);
            return;
        }
        try {
            source = ObjectHelper.requireNonNull(this.completableFunction.apply(resource), "The completableFunction returned a null CompletableSource");
        }
        catch (Throwable ex3) {
            Exceptions.throwIfFatal(ex3);
            if (this.eager) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    EmptyDisposable.error((Throwable)new CompositeException(ex3, exc), observer);
                    return;
                }
            }
            EmptyDisposable.error(ex3, observer);
            if (!this.eager) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    RxJavaPlugins.onError(exc);
                }
            }
            return;
        }
        source.subscribe(new CompletableUsing$UsingObserver<R>(observer, resource, this.disposer, this.eager));
    }
}

