/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.internal.operators.completable.CompletableMergeDelayErrorArray$MergeInnerCompletableObserver;
import io.reactivex.internal.util.AtomicThrowable;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableMergeDelayErrorArray
extends Completable {
    final CompletableSource[] sources;

    public CompletableMergeDelayErrorArray(CompletableSource[] sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver s2) {
        CompositeDisposable set = new CompositeDisposable();
        AtomicInteger wip = new AtomicInteger(this.sources.length + 1);
        AtomicThrowable error = new AtomicThrowable();
        s2.onSubscribe(set);
        for (CompletableSource c2 : this.sources) {
            if (set.isDisposed()) {
                return;
            }
            if (c2 == null) {
                NullPointerException ex2 = new NullPointerException("A completable source is null");
                error.addThrowable(ex2);
                wip.decrementAndGet();
                continue;
            }
            c2.subscribe(new CompletableMergeDelayErrorArray$MergeInnerCompletableObserver(s2, set, error, wip));
        }
        if (wip.decrementAndGet() == 0) {
            Throwable ex3 = error.terminate();
            if (ex3 == null) {
                s2.onComplete();
            } else {
                s2.onError(ex3);
            }
        }
    }
}

