/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.operators.completable.CompletableMerge$CompletableMergeSubscriber$MergeInnerObserver;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

final class CompletableMerge$CompletableMergeSubscriber
extends AtomicInteger
implements FlowableSubscriber<CompletableSource>,
Disposable {
    private static final long serialVersionUID = -2108443387387077490L;
    final CompletableObserver actual;
    final int maxConcurrency;
    final boolean delayErrors;
    final AtomicThrowable error;
    final CompositeDisposable set;
    Yy s;

    CompletableMerge$CompletableMergeSubscriber(CompletableObserver actual, int maxConcurrency, boolean delayErrors) {
        this.actual = actual;
        this.maxConcurrency = maxConcurrency;
        this.delayErrors = delayErrors;
        this.set = new CompositeDisposable();
        this.error = new AtomicThrowable();
        this.lazySet(1);
    }

    @Override
    public void dispose() {
        this.s.cancel();
        this.set.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.set.isDisposed();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            if (this.maxConcurrency == Integer.MAX_VALUE) {
                s2.request(Long.MAX_VALUE);
            } else {
                s2.request(this.maxConcurrency);
            }
        }
    }

    @Override
    public void onNext(CompletableSource t2) {
        this.getAndIncrement();
        CompletableMerge$CompletableMergeSubscriber$MergeInnerObserver inner = new CompletableMerge$CompletableMergeSubscriber$MergeInnerObserver(this);
        this.set.add(inner);
        t2.subscribe(inner);
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.delayErrors) {
            this.set.dispose();
            if (this.error.addThrowable(t2)) {
                if (this.getAndSet(0) > 0) {
                    this.actual.onError(this.error.terminate());
                }
            } else {
                RxJavaPlugins.onError(t2);
            }
        } else if (this.error.addThrowable(t2)) {
            if (this.decrementAndGet() == 0) {
                this.actual.onError(this.error.terminate());
            }
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.decrementAndGet() == 0) {
            Throwable ex2 = (Throwable)this.error.get();
            if (ex2 != null) {
                this.actual.onError(this.error.terminate());
            } else {
                this.actual.onComplete();
            }
        }
    }

    void innerError(CompletableMerge$CompletableMergeSubscriber$MergeInnerObserver inner, Throwable t2) {
        this.set.delete(inner);
        if (!this.delayErrors) {
            this.s.cancel();
            this.set.dispose();
            if (this.error.addThrowable(t2)) {
                if (this.getAndSet(0) > 0) {
                    this.actual.onError(this.error.terminate());
                }
            } else {
                RxJavaPlugins.onError(t2);
            }
        } else if (this.error.addThrowable(t2)) {
            if (this.decrementAndGet() == 0) {
                this.actual.onError(this.error.terminate());
            } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                this.s.request(1L);
            }
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    void innerComplete(CompletableMerge$CompletableMergeSubscriber$MergeInnerObserver inner) {
        this.set.delete(inner);
        if (this.decrementAndGet() == 0) {
            Throwable ex2 = (Throwable)this.error.get();
            if (ex2 != null) {
                this.actual.onError(ex2);
            } else {
                this.actual.onComplete();
            }
        } else if (this.maxConcurrency != Integer.MAX_VALUE) {
            this.s.request(1L);
        }
    }
}

