/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.Exceptions;

public final class CompletableFromRunnable
extends Completable {
    final Runnable runnable;

    public CompletableFromRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public void subscribeActual(CompletableObserver s2) {
        Disposable d2 = Disposables.empty();
        s2.onSubscribe(d2);
        try {
            this.runnable.run();
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            if (!d2.isDisposed()) {
                s2.onError(e2);
            }
            return;
        }
        if (!d2.isDisposed()) {
            s2.onComplete();
        }
    }
}

