/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Cancellable;
import io.reactivex.internal.disposables.CancellableDisposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

final class CompletableCreate$Emitter
extends AtomicReference<Disposable>
implements CompletableEmitter,
Disposable {
    private static final long serialVersionUID = -2467358622224974244L;
    final CompletableObserver actual;

    CompletableCreate$Emitter(CompletableObserver actual) {
        this.actual = actual;
    }

    @Override
    public void onComplete() {
        Disposable d2;
        if (this.get() != DisposableHelper.DISPOSED && (d2 = (Disposable)this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
            try {
                this.actual.onComplete();
            }
            finally {
                if (d2 != null) {
                    d2.dispose();
                }
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.tryOnError(t2)) {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public boolean tryOnError(Throwable t2) {
        Disposable d2;
        if (t2 == null) {
            t2 = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        if (this.get() != DisposableHelper.DISPOSED && (d2 = (Disposable)this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
            try {
                this.actual.onError(t2);
            }
            finally {
                if (d2 != null) {
                    d2.dispose();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void setDisposable(Disposable d2) {
        DisposableHelper.set(this, d2);
    }

    @Override
    public void setCancellable(Cancellable c2) {
        this.setDisposable(new CancellableDisposable(c2));
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }
}

