/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

final class CompletableConcatIterable$ConcatInnerObserver
extends AtomicInteger
implements CompletableObserver {
    private static final long serialVersionUID = -7965400327305809232L;
    final CompletableObserver actual;
    final Iterator<? extends CompletableSource> sources;
    final SequentialDisposable sd;

    CompletableConcatIterable$ConcatInnerObserver(CompletableObserver actual, Iterator<? extends CompletableSource> sources) {
        this.actual = actual;
        this.sources = sources;
        this.sd = new SequentialDisposable();
    }

    @Override
    public void onSubscribe(Disposable d2) {
        this.sd.replace(d2);
    }

    @Override
    public void onError(Throwable e2) {
        this.actual.onError(e2);
    }

    @Override
    public void onComplete() {
        this.next();
    }

    void next() {
        if (this.sd.isDisposed()) {
            return;
        }
        if (this.getAndIncrement() != 0) {
            return;
        }
        Iterator<? extends CompletableSource> a2 = this.sources;
        do {
            CompletableSource c2;
            boolean b2;
            if (this.sd.isDisposed()) {
                return;
            }
            try {
                b2 = a2.hasNext();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.actual.onError(ex2);
                return;
            }
            if (!b2) {
                this.actual.onComplete();
                return;
            }
            try {
                c2 = ObjectHelper.requireNonNull(a2.next(), "The CompletableSource returned is null");
            }
            catch (Throwable ex3) {
                Exceptions.throwIfFatal(ex3);
                this.actual.onError(ex3);
                return;
            }
            c2.subscribe(this);
        } while (this.decrementAndGet() != 0);
    }
}

