/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.completable.CompletableConcat$CompletableConcatSubscriber$ConcatInnerObserver;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

final class CompletableConcat$CompletableConcatSubscriber
extends AtomicInteger
implements FlowableSubscriber<CompletableSource>,
Disposable {
    private static final long serialVersionUID = 9032184911934499404L;
    final CompletableObserver actual;
    final int prefetch;
    final int limit;
    final CompletableConcat$CompletableConcatSubscriber$ConcatInnerObserver inner;
    final AtomicBoolean once;
    int sourceFused;
    int consumed;
    SimpleQueue<CompletableSource> queue;
    Yy s;
    volatile boolean done;
    volatile boolean active;

    CompletableConcat$CompletableConcatSubscriber(CompletableObserver actual, int prefetch) {
        this.actual = actual;
        this.prefetch = prefetch;
        this.inner = new CompletableConcat$CompletableConcatSubscriber$ConcatInnerObserver(this);
        this.once = new AtomicBoolean();
        this.limit = prefetch - (prefetch >> 2);
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            long r2;
            this.s = s2;
            long l2 = r2 = this.prefetch == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.prefetch;
            if (s2 instanceof QueueSubscription) {
                QueueSubscription qs2 = (QueueSubscription)s2;
                int m2 = qs2.requestFusion(3);
                if (m2 == 1) {
                    this.sourceFused = m2;
                    this.queue = qs2;
                    this.done = true;
                    this.actual.onSubscribe(this);
                    this.drain();
                    return;
                }
                if (m2 == 2) {
                    this.sourceFused = m2;
                    this.queue = qs2;
                    this.actual.onSubscribe(this);
                    s2.request(r2);
                    return;
                }
            }
            this.queue = this.prefetch == Integer.MAX_VALUE ? new SpscLinkedArrayQueue<CompletableSource>(Flowable.bufferSize()) : new SpscArrayQueue<CompletableSource>(this.prefetch);
            this.actual.onSubscribe(this);
            s2.request(r2);
        }
    }

    @Override
    public void onNext(CompletableSource t2) {
        if (this.sourceFused == 0 && !this.queue.offer(t2)) {
            this.onError(new MissingBackpressureException());
            return;
        }
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        if (this.once.compareAndSet(false, true)) {
            DisposableHelper.dispose(this.inner);
            this.actual.onError(t2);
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    public void dispose() {
        this.s.cancel();
        DisposableHelper.dispose(this.inner);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.inner.get());
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        do {
            boolean empty;
            CompletableSource cs2;
            if (this.isDisposed()) {
                return;
            }
            if (this.active) continue;
            boolean d2 = this.done;
            try {
                cs2 = this.queue.poll();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.innerError(ex2);
                return;
            }
            boolean bl2 = empty = cs2 == null;
            if (d2 && empty) {
                if (this.once.compareAndSet(false, true)) {
                    this.actual.onComplete();
                }
                return;
            }
            if (empty) continue;
            this.active = true;
            cs2.subscribe(this.inner);
            this.request();
        } while (this.decrementAndGet() != 0);
    }

    void request() {
        if (this.sourceFused != 1) {
            int p2 = this.consumed + 1;
            if (p2 == this.limit) {
                this.consumed = 0;
                this.s.request(p2);
            } else {
                this.consumed = p2;
            }
        }
    }

    void innerError(Throwable e2) {
        if (this.once.compareAndSet(false, true)) {
            this.s.cancel();
            this.actual.onError(e2);
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    void innerComplete() {
        this.active = false;
        this.drain();
    }
}

