/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.annotations.Experimental;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.operators.completable.CompletableCache$InnerCompletableCache;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@Experimental
public final class CompletableCache
extends Completable
implements CompletableObserver {
    static final CompletableCache$InnerCompletableCache[] EMPTY = new CompletableCache$InnerCompletableCache[0];
    static final CompletableCache$InnerCompletableCache[] TERMINATED = new CompletableCache$InnerCompletableCache[0];
    final CompletableSource source;
    final AtomicReference<CompletableCache$InnerCompletableCache[]> observers;
    final AtomicBoolean once;
    Throwable error;

    public CompletableCache(CompletableSource source) {
        this.source = source;
        this.observers = new AtomicReference<CompletableCache$InnerCompletableCache[]>(EMPTY);
        this.once = new AtomicBoolean();
    }

    @Override
    public void subscribeActual(CompletableObserver s2) {
        CompletableCache$InnerCompletableCache inner = new CompletableCache$InnerCompletableCache(this, s2);
        s2.onSubscribe(inner);
        if (this.add(inner)) {
            if (inner.isDisposed()) {
                this.remove(inner);
            }
            if (this.once.compareAndSet(false, true)) {
                this.source.subscribe(this);
            }
        } else {
            Throwable ex2 = this.error;
            if (ex2 != null) {
                s2.onError(ex2);
            } else {
                s2.onComplete();
            }
        }
    }

    @Override
    public void onSubscribe(Disposable d2) {
    }

    @Override
    public void onError(Throwable e2) {
        this.error = e2;
        for (CompletableCache$InnerCompletableCache inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.get()) continue;
            inner.actual.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        for (CompletableCache$InnerCompletableCache inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.get()) continue;
            inner.actual.onComplete();
        }
    }

    boolean add(CompletableCache$InnerCompletableCache inner) {
        CompletableCache$InnerCompletableCache[] b2;
        CompletableCache$InnerCompletableCache[] a2;
        do {
            if ((a2 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n2 = a2.length;
            b2 = new CompletableCache$InnerCompletableCache[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = inner;
        } while (!this.observers.compareAndSet(a2, b2));
        return true;
    }

    void remove(CompletableCache$InnerCompletableCache inner) {
        CompletableCache$InnerCompletableCache[] b2;
        CompletableCache$InnerCompletableCache[] a2;
        do {
            int n2;
            if ((n2 = (a2 = this.observers.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a2[i2] != inner) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new CompletableCache$InnerCompletableCache[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.observers.compareAndSet(a2, b2));
    }
}

