/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.completable.CompletableAmb$Amb;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CompletableAmb
extends Completable {
    private final CompletableSource[] sources;
    private final Iterable<? extends CompletableSource> sourcesIterable;

    public CompletableAmb(CompletableSource[] sources, Iterable<? extends CompletableSource> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    @Override
    public void subscribeActual(CompletableObserver s2) {
        CompletableSource[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new CompletableSource[8];
            try {
                for (CompletableSource completableSource : this.sourcesIterable) {
                    if (completableSource == null) {
                        EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), s2);
                        return;
                    }
                    if (count == sources.length) {
                        CompletableSource[] b2 = new CompletableSource[count + (count >> 2)];
                        System.arraycopy(sources, 0, b2, 0, count);
                        sources = b2;
                    }
                    sources[count++] = completableSource;
                }
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                EmptyDisposable.error(e2, s2);
                return;
            }
        } else {
            count = sources.length;
        }
        CompositeDisposable set = new CompositeDisposable();
        s2.onSubscribe(set);
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        CompletableAmb$Amb inner = new CompletableAmb$Amb(atomicBoolean, set, s2);
        for (int i2 = 0; i2 < count; ++i2) {
            CompletableSource c2 = sources[i2];
            if (set.isDisposed()) {
                return;
            }
            if (c2 == null) {
                NullPointerException npe = new NullPointerException("One of the sources is null");
                if (atomicBoolean.compareAndSet(false, true)) {
                    set.dispose();
                    s2.onError(npe);
                } else {
                    RxJavaPlugins.onError(npe);
                }
                return;
            }
            c2.subscribe(inner);
        }
        if (count == 0) {
            s2.onComplete();
        }
    }
}

