/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.observers;

import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.OnErrorNotImplementedException;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.observers.LambdaConsumerIntrospection;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class CallbackCompletableObserver
extends AtomicReference<Disposable>
implements CompletableObserver,
Disposable,
Consumer<Throwable>,
LambdaConsumerIntrospection {
    private static final long serialVersionUID = -4361286194466301354L;
    final Consumer<? super Throwable> onError;
    final Action onComplete;

    public CallbackCompletableObserver(Action onComplete) {
        this.onError = this;
        this.onComplete = onComplete;
    }

    public CallbackCompletableObserver(Consumer<? super Throwable> onError, Action onComplete) {
        this.onError = onError;
        this.onComplete = onComplete;
    }

    @Override
    public void accept(Throwable e2) {
        RxJavaPlugins.onError(new OnErrorNotImplementedException(e2));
    }

    @Override
    public void onComplete() {
        try {
            this.onComplete.run();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            RxJavaPlugins.onError(ex2);
        }
        this.lazySet(DisposableHelper.DISPOSED);
    }

    @Override
    public void onError(Throwable e2) {
        try {
            this.onError.accept(e2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            RxJavaPlugins.onError(ex2);
        }
        this.lazySet(DisposableHelper.DISPOSED);
    }

    @Override
    public void onSubscribe(Disposable d2) {
        DisposableHelper.setOnce(this, d2);
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == DisposableHelper.DISPOSED;
    }

    @Override
    public boolean hasCustomOnError() {
        return this.onError != this;
    }
}

