/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.observers;

import io.reactivex.CompletableObserver;
import io.reactivex.MaybeObserver;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class BlockingMultiObserver<T>
extends CountDownLatch
implements CompletableObserver,
MaybeObserver<T>,
SingleObserver<T> {
    T value;
    Throwable error;
    Disposable d;
    volatile boolean cancelled;

    public BlockingMultiObserver() {
        super(1);
    }

    void dispose() {
        this.cancelled = true;
        Disposable d2 = this.d;
        if (d2 != null) {
            d2.dispose();
        }
    }

    @Override
    public void onSubscribe(Disposable d2) {
        this.d = d2;
        if (this.cancelled) {
            d2.dispose();
        }
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        this.countDown();
    }

    @Override
    public void onError(Throwable e2) {
        this.error = e2;
        this.countDown();
    }

    @Override
    public void onComplete() {
        this.countDown();
    }

    public T blockingGet() {
        Throwable ex2;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex3) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex3);
            }
        }
        if ((ex2 = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(ex2);
        }
        return this.value;
    }

    public T blockingGet(T defaultValue) {
        Throwable ex2;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex3) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex3);
            }
        }
        if ((ex2 = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(ex2);
        }
        T v2 = this.value;
        return v2 != null ? v2 : defaultValue;
    }

    public Throwable blockingGetError() {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex2) {
                this.dispose();
                return ex2;
            }
        }
        return this.error;
    }

    public Throwable blockingGetError(long timeout, TimeUnit unit) {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                if (!this.await(timeout, unit)) {
                    this.dispose();
                    throw ExceptionHelper.wrapOrThrow(new TimeoutException());
                }
            }
            catch (InterruptedException ex2) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
        }
        return this.error;
    }

    public boolean blockingAwait(long timeout, TimeUnit unit) {
        Throwable ex2;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                if (!this.await(timeout, unit)) {
                    this.dispose();
                    return false;
                }
            }
            catch (InterruptedException ex3) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex3);
            }
        }
        if ((ex2 = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(ex2);
        }
        return true;
    }
}

