/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.observers;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.concurrent.CountDownLatch;

public abstract class BlockingBaseObserver<T>
extends CountDownLatch
implements Observer<T>,
Disposable {
    T value;
    Throwable error;
    Disposable d;
    volatile boolean cancelled;

    public BlockingBaseObserver() {
        super(1);
    }

    @Override
    public final void onSubscribe(Disposable d2) {
        this.d = d2;
        if (this.cancelled) {
            d2.dispose();
        }
    }

    @Override
    public final void onComplete() {
        this.countDown();
    }

    @Override
    public final void dispose() {
        this.cancelled = true;
        Disposable d2 = this.d;
        if (d2 != null) {
            d2.dispose();
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.cancelled;
    }

    public final T blockingGet() {
        Throwable e2;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex2) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
        }
        if ((e2 = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(e2);
        }
        return this.value;
    }
}

