/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.functions;

import io.reactivex.Notification;
import io.reactivex.Scheduler;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.BooleanSupplier;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function3;
import io.reactivex.functions.Function4;
import io.reactivex.functions.Function5;
import io.reactivex.functions.Function6;
import io.reactivex.functions.Function7;
import io.reactivex.functions.Function8;
import io.reactivex.functions.Function9;
import io.reactivex.functions.LongConsumer;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions$ActionConsumer;
import io.reactivex.internal.functions.Functions$Array2Func;
import io.reactivex.internal.functions.Functions$Array3Func;
import io.reactivex.internal.functions.Functions$Array4Func;
import io.reactivex.internal.functions.Functions$Array5Func;
import io.reactivex.internal.functions.Functions$Array6Func;
import io.reactivex.internal.functions.Functions$Array7Func;
import io.reactivex.internal.functions.Functions$Array8Func;
import io.reactivex.internal.functions.Functions$Array9Func;
import io.reactivex.internal.functions.Functions$ArrayListCapacityCallable;
import io.reactivex.internal.functions.Functions$BooleanSupplierPredicateReverse;
import io.reactivex.internal.functions.Functions$CastToClass;
import io.reactivex.internal.functions.Functions$ClassFilter;
import io.reactivex.internal.functions.Functions$EmptyAction;
import io.reactivex.internal.functions.Functions$EmptyConsumer;
import io.reactivex.internal.functions.Functions$EmptyLongConsumer;
import io.reactivex.internal.functions.Functions$EmptyRunnable;
import io.reactivex.internal.functions.Functions$EqualsPredicate;
import io.reactivex.internal.functions.Functions$ErrorConsumer;
import io.reactivex.internal.functions.Functions$FalsePredicate;
import io.reactivex.internal.functions.Functions$FutureAction;
import io.reactivex.internal.functions.Functions$HashSetCallable;
import io.reactivex.internal.functions.Functions$Identity;
import io.reactivex.internal.functions.Functions$JustValue;
import io.reactivex.internal.functions.Functions$ListSorter;
import io.reactivex.internal.functions.Functions$MaxRequestSubscription;
import io.reactivex.internal.functions.Functions$NaturalComparator;
import io.reactivex.internal.functions.Functions$NaturalObjectComparator;
import io.reactivex.internal.functions.Functions$NotificationOnComplete;
import io.reactivex.internal.functions.Functions$NotificationOnError;
import io.reactivex.internal.functions.Functions$NotificationOnNext;
import io.reactivex.internal.functions.Functions$NullCallable;
import io.reactivex.internal.functions.Functions$OnErrorMissingConsumer;
import io.reactivex.internal.functions.Functions$TimestampFunction;
import io.reactivex.internal.functions.Functions$ToMapKeySelector;
import io.reactivex.internal.functions.Functions$ToMapKeyValueSelector;
import io.reactivex.internal.functions.Functions$ToMultimapKeyValueSelector;
import io.reactivex.internal.functions.Functions$TruePredicate;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.schedulers.Timed;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class Functions {
    static final Function<Object, Object> IDENTITY = new Functions$Identity();
    public static final Runnable EMPTY_RUNNABLE = new Functions$EmptyRunnable();
    public static final Action EMPTY_ACTION = new Functions$EmptyAction();
    static final Consumer<Object> EMPTY_CONSUMER = new Functions$EmptyConsumer();
    public static final Consumer<Throwable> ERROR_CONSUMER = new Functions$ErrorConsumer();
    public static final Consumer<Throwable> ON_ERROR_MISSING = new Functions$OnErrorMissingConsumer();
    public static final LongConsumer EMPTY_LONG_CONSUMER = new Functions$EmptyLongConsumer();
    static final Predicate<Object> ALWAYS_TRUE = new Functions$TruePredicate();
    static final Predicate<Object> ALWAYS_FALSE = new Functions$FalsePredicate();
    static final Callable<Object> NULL_SUPPLIER = new Functions$NullCallable();
    static final Comparator<Object> NATURAL_COMPARATOR = new Functions$NaturalObjectComparator();
    public static final Consumer<Yy> REQUEST_MAX = new Functions$MaxRequestSubscription();

    private Functions() {
        throw new IllegalStateException("No instances!");
    }

    public static <T1, T2, R> Function<Object[], R> toFunction(BiFunction<? super T1, ? super T2, ? extends R> f2) {
        ObjectHelper.requireNonNull(f2, "f is null");
        return new Functions$Array2Func<T1, T2, R>(f2);
    }

    public static <T1, T2, T3, R> Function<Object[], R> toFunction(Function3<T1, T2, T3, R> f2) {
        ObjectHelper.requireNonNull(f2, "f is null");
        return new Functions$Array3Func<T1, T2, T3, R>(f2);
    }

    public static <T1, T2, T3, T4, R> Function<Object[], R> toFunction(Function4<T1, T2, T3, T4, R> f2) {
        ObjectHelper.requireNonNull(f2, "f is null");
        return new Functions$Array4Func<T1, T2, T3, T4, R>(f2);
    }

    public static <T1, T2, T3, T4, T5, R> Function<Object[], R> toFunction(Function5<T1, T2, T3, T4, T5, R> f2) {
        ObjectHelper.requireNonNull(f2, "f is null");
        return new Functions$Array5Func<T1, T2, T3, T4, T5, R>(f2);
    }

    public static <T1, T2, T3, T4, T5, T6, R> Function<Object[], R> toFunction(Function6<T1, T2, T3, T4, T5, T6, R> f2) {
        ObjectHelper.requireNonNull(f2, "f is null");
        return new Functions$Array6Func<T1, T2, T3, T4, T5, T6, R>(f2);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Function<Object[], R> toFunction(Function7<T1, T2, T3, T4, T5, T6, T7, R> f2) {
        ObjectHelper.requireNonNull(f2, "f is null");
        return new Functions$Array7Func<T1, T2, T3, T4, T5, T6, T7, R>(f2);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Function<Object[], R> toFunction(Function8<T1, T2, T3, T4, T5, T6, T7, T8, R> f2) {
        ObjectHelper.requireNonNull(f2, "f is null");
        return new Functions$Array8Func<T1, T2, T3, T4, T5, T6, T7, T8, R>(f2);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Function<Object[], R> toFunction(Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, R> f2) {
        ObjectHelper.requireNonNull(f2, "f is null");
        return new Functions$Array9Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, R>(f2);
    }

    public static <T> Function<T, T> identity() {
        return IDENTITY;
    }

    public static <T> Consumer<T> emptyConsumer() {
        return EMPTY_CONSUMER;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static <T> Callable<T> nullSupplier() {
        return NULL_SUPPLIER;
    }

    public static <T> Comparator<T> naturalOrder() {
        return NATURAL_COMPARATOR;
    }

    public static Action futureAction(Future<?> future) {
        return new Functions$FutureAction(future);
    }

    public static <T> Callable<T> justCallable(T value) {
        return new Functions$JustValue(value);
    }

    public static <T, U> Function<T, U> justFunction(U value) {
        return new Functions$JustValue(value);
    }

    public static <T, U> Function<T, U> castFunction(Class<U> target) {
        return new Functions$CastToClass(target);
    }

    public static <T> Callable<List<T>> createArrayList(int capacity) {
        return new Functions$ArrayListCapacityCallable(capacity);
    }

    public static <T> Predicate<T> equalsWith(T value) {
        return new Functions$EqualsPredicate<T>(value);
    }

    public static <T> Callable<Set<T>> createHashSet() {
        return Functions$HashSetCallable.INSTANCE;
    }

    public static <T> Consumer<T> notificationOnNext(Consumer<? super Notification<T>> onNotification) {
        return new Functions$NotificationOnNext(onNotification);
    }

    public static <T> Consumer<Throwable> notificationOnError(Consumer<? super Notification<T>> onNotification) {
        return new Functions$NotificationOnError(onNotification);
    }

    public static <T> Action notificationOnComplete(Consumer<? super Notification<T>> onNotification) {
        return new Functions$NotificationOnComplete(onNotification);
    }

    public static <T> Consumer<T> actionConsumer(Action action) {
        return new Functions$ActionConsumer(action);
    }

    public static <T, U> Predicate<T> isInstanceOf(Class<U> clazz) {
        return new Functions$ClassFilter(clazz);
    }

    public static <T> Predicate<T> predicateReverseFor(BooleanSupplier supplier) {
        return new Functions$BooleanSupplierPredicateReverse(supplier);
    }

    public static <T> Function<T, Timed<T>> timestampWith(TimeUnit unit, Scheduler scheduler) {
        return new Functions$TimestampFunction(unit, scheduler);
    }

    public static <T, K> BiConsumer<Map<K, T>, T> toMapKeySelector(Function<? super T, ? extends K> keySelector) {
        return new Functions$ToMapKeySelector<K, T>(keySelector);
    }

    public static <T, K, V> BiConsumer<Map<K, V>, T> toMapKeyValueSelector(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        return new Functions$ToMapKeyValueSelector<K, V, T>(valueSelector, keySelector);
    }

    public static <T, K, V> BiConsumer<Map<K, Collection<V>>, T> toMultimapKeyValueSelector(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Function<? super K, ? extends Collection<? super V>> collectionFactory) {
        return new Functions$ToMultimapKeyValueSelector<K, V, T>(collectionFactory, valueSelector, keySelector);
    }

    public static <T> Comparator<T> naturalComparator() {
        return Functions$NaturalComparator.INSTANCE;
    }

    public static <T> Function<List<T>, List<T>> listSorter(Comparator<? super T> comparator) {
        return new Functions$ListSorter<T>(comparator);
    }
}

