/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.disposables;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.disposables.FullArbiterPad1;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;

public final class ObserverFullArbiter<T>
extends FullArbiterPad1
implements Disposable {
    final Observer<? super T> actual;
    final SpscLinkedArrayQueue<Object> queue;
    volatile Disposable s;
    Disposable resource;
    volatile boolean cancelled;

    public ObserverFullArbiter(Observer<? super T> actual, Disposable resource, int capacity) {
        this.actual = actual;
        this.resource = resource;
        this.queue = new SpscLinkedArrayQueue(capacity);
        this.s = EmptyDisposable.INSTANCE;
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.disposeResource();
        }
    }

    @Override
    public boolean isDisposed() {
        Disposable d2 = this.resource;
        return d2 != null ? d2.isDisposed() : this.cancelled;
    }

    void disposeResource() {
        Disposable d2 = this.resource;
        this.resource = null;
        if (d2 != null) {
            d2.dispose();
        }
    }

    public boolean setDisposable(Disposable s2) {
        if (this.cancelled) {
            return false;
        }
        this.queue.offer(this.s, NotificationLite.disposable(s2));
        this.drain();
        return true;
    }

    public boolean onNext(T value, Disposable s2) {
        if (this.cancelled) {
            return false;
        }
        this.queue.offer(s2, NotificationLite.next(value));
        this.drain();
        return true;
    }

    public void onError(Throwable value, Disposable s2) {
        if (this.cancelled) {
            RxJavaPlugins.onError(value);
            return;
        }
        this.queue.offer(s2, NotificationLite.error(value));
        this.drain();
    }

    public void onComplete(Disposable s2) {
        this.queue.offer(s2, NotificationLite.complete());
        this.drain();
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        SpscLinkedArrayQueue<Object> q2 = this.queue;
        Observer a2 = this.actual;
        while (true) {
            Object o2;
            if ((o2 = q2.poll()) != null) {
                Object v2 = q2.poll();
                if (o2 != this.s) continue;
                if (NotificationLite.isDisposable(v2)) {
                    Disposable next = NotificationLite.getDisposable(v2);
                    this.s.dispose();
                    if (!this.cancelled) {
                        this.s = next;
                        continue;
                    }
                    next.dispose();
                    continue;
                }
                if (NotificationLite.isError(v2)) {
                    q2.clear();
                    this.disposeResource();
                    Throwable ex2 = NotificationLite.getError(v2);
                    if (!this.cancelled) {
                        this.cancelled = true;
                        a2.onError(ex2);
                        continue;
                    }
                    RxJavaPlugins.onError(ex2);
                    continue;
                }
                if (NotificationLite.isComplete(v2)) {
                    q2.clear();
                    this.disposeResource();
                    if (this.cancelled) continue;
                    this.cancelled = true;
                    a2.onComplete();
                    continue;
                }
                a2.onNext(NotificationLite.getValue(v2));
                continue;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
        }
    }
}

