/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.disposables;

import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.ProtocolViolationException;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public enum DisposableHelper implements Disposable
{
    DISPOSED;


    public static boolean isDisposed(Disposable d2) {
        return d2 == DISPOSED;
    }

    public static boolean set(AtomicReference<Disposable> field, Disposable d2) {
        Disposable current;
        do {
            if ((current = field.get()) != DISPOSED) continue;
            if (d2 != null) {
                d2.dispose();
            }
            return false;
        } while (!field.compareAndSet(current, d2));
        if (current != null) {
            current.dispose();
        }
        return true;
    }

    public static boolean setOnce(AtomicReference<Disposable> field, Disposable d2) {
        ObjectHelper.requireNonNull(d2, "d is null");
        if (!field.compareAndSet(null, d2)) {
            d2.dispose();
            if (field.get() != DISPOSED) {
                DisposableHelper.reportDisposableSet();
            }
            return false;
        }
        return true;
    }

    public static boolean replace(AtomicReference<Disposable> field, Disposable d2) {
        Disposable current;
        do {
            if ((current = field.get()) != DISPOSED) continue;
            if (d2 != null) {
                d2.dispose();
            }
            return false;
        } while (!field.compareAndSet(current, d2));
        return true;
    }

    public static boolean dispose(AtomicReference<Disposable> field) {
        DisposableHelper d2;
        Disposable current = field.get();
        if (current != (d2 = DISPOSED) && (current = field.getAndSet(d2)) != d2) {
            if (current != null) {
                current.dispose();
            }
            return true;
        }
        return false;
    }

    public static boolean validate(Disposable current, Disposable next) {
        if (next == null) {
            RxJavaPlugins.onError(new NullPointerException("next is null"));
            return false;
        }
        if (current != null) {
            next.dispose();
            DisposableHelper.reportDisposableSet();
            return false;
        }
        return true;
    }

    public static void reportDisposableSet() {
        RxJavaPlugins.onError(new ProtocolViolationException("Disposable already set!"));
    }

    public static boolean trySet(AtomicReference<Disposable> field, Disposable d2) {
        if (!field.compareAndSet(null, d2)) {
            if (field.get() == DISPOSED) {
                d2.dispose();
            }
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return true;
    }
}

