/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.exceptions;

import io.reactivex.annotations.NonNull;
import io.reactivex.exceptions.CompositeException$CompositeExceptionCausalChain;
import io.reactivex.exceptions.CompositeException$PrintStreamOrWriter;
import io.reactivex.exceptions.CompositeException$WrappedPrintStream;
import io.reactivex.exceptions.CompositeException$WrappedPrintWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public final class CompositeException
extends RuntimeException {
    private static final long serialVersionUID = 3026362227162912146L;
    private final List<Throwable> exceptions;
    private final String message;
    private Throwable cause;

    public CompositeException(Throwable ... exceptions) {
        this(exceptions == null ? Collections.singletonList(new NullPointerException("exceptions was null")) : Arrays.asList(exceptions));
    }

    public CompositeException(@NonNull Iterable<? extends Throwable> errors) {
        LinkedHashSet<Throwable> deDupedExceptions = new LinkedHashSet<Throwable>();
        ArrayList<Throwable> localExceptions = new ArrayList<Throwable>();
        if (errors != null) {
            for (Throwable throwable : errors) {
                if (throwable instanceof CompositeException) {
                    deDupedExceptions.addAll(((CompositeException)throwable).getExceptions());
                    continue;
                }
                if (throwable != null) {
                    deDupedExceptions.add(throwable);
                    continue;
                }
                deDupedExceptions.add(new NullPointerException("Throwable was null!"));
            }
        } else {
            deDupedExceptions.add(new NullPointerException("errors was null"));
        }
        if (deDupedExceptions.isEmpty()) {
            throw new IllegalArgumentException("errors is empty");
        }
        localExceptions.addAll(deDupedExceptions);
        this.exceptions = Collections.unmodifiableList(localExceptions);
        this.message = this.exceptions.size() + " exceptions occurred. ";
    }

    @NonNull
    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    @NonNull
    public String getMessage() {
        return this.message;
    }

    @Override
    @NonNull
    public synchronized Throwable getCause() {
        if (this.cause == null) {
            CompositeException$CompositeExceptionCausalChain localCause = new CompositeException$CompositeExceptionCausalChain();
            HashSet<Throwable> seenCauses = new HashSet<Throwable>();
            Throwable chain = localCause;
            for (Throwable e2 : this.exceptions) {
                if (seenCauses.contains(e2)) continue;
                seenCauses.add(e2);
                List<Throwable> listOfCauses = this.getListOfCauses(e2);
                for (Throwable child : listOfCauses) {
                    if (seenCauses.contains(child)) {
                        e2 = new RuntimeException("Duplicate found in causal chain so cropping to prevent loop ...");
                        continue;
                    }
                    seenCauses.add(child);
                }
                try {
                    chain.initCause(e2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                chain = this.getRootCause(chain);
            }
            this.cause = localCause;
        }
        return this.cause;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s2) {
        this.printStackTrace(new CompositeException$WrappedPrintStream(s2));
    }

    @Override
    public void printStackTrace(PrintWriter s2) {
        this.printStackTrace(new CompositeException$WrappedPrintWriter(s2));
    }

    private void printStackTrace(CompositeException$PrintStreamOrWriter s2) {
        StringBuilder b2 = new StringBuilder(128);
        b2.append(this).append('\n');
        for (StackTraceElement myStackElement : this.getStackTrace()) {
            b2.append("\tat ").append(myStackElement).append('\n');
        }
        int i2 = 1;
        for (Throwable ex2 : this.exceptions) {
            b2.append("  ComposedException ").append(i2).append(" :\n");
            this.appendStackTrace(b2, ex2, "\t");
            ++i2;
        }
        s2.println(b2.toString());
    }

    private void appendStackTrace(StringBuilder b2, Throwable ex2, String prefix) {
        b2.append(prefix).append(ex2).append('\n');
        for (StackTraceElement stackElement : ex2.getStackTrace()) {
            b2.append("\t\tat ").append(stackElement).append('\n');
        }
        if (ex2.getCause() != null) {
            b2.append("\tCaused by: ");
            this.appendStackTrace(b2, ex2.getCause(), "");
        }
    }

    private List<Throwable> getListOfCauses(Throwable ex2) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        Throwable root = ex2.getCause();
        if (root == null || root == ex2) {
            return list;
        }
        while (true) {
            list.add(root);
            Throwable cause = root.getCause();
            if (cause == null || cause == root) {
                return list;
            }
            root = cause;
        }
    }

    public int size() {
        return this.exceptions.size();
    }

    private Throwable getRootCause(Throwable e2) {
        Throwable root = e2.getCause();
        if (root == null || this.cause == root) {
            return e2;
        }
        Throwable cause;
        while ((cause = root.getCause()) != null && cause != root) {
            root = cause;
        }
        return root;
    }
}

