/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Scheduler$DisposeTask;
import io.reactivex.Scheduler$PeriodicDirectTask;
import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.schedulers.SchedulerWhen;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;

public abstract class Scheduler {
    static final long CLOCK_DRIFT_TOLERANCE_NANOSECONDS = TimeUnit.MINUTES.toNanos(Long.getLong("rx2.scheduler.drift-tolerance", 15L));

    public static long clockDriftTolerance() {
        return CLOCK_DRIFT_TOLERANCE_NANOSECONDS;
    }

    @NonNull
    public abstract Scheduler$Worker createWorker();

    public long now(@NonNull TimeUnit unit) {
        return unit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public void start() {
    }

    public void shutdown() {
    }

    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run) {
        return this.scheduleDirect(run, 0L, TimeUnit.NANOSECONDS);
    }

    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run, long delay, @NonNull TimeUnit unit) {
        Scheduler$Worker w2 = this.createWorker();
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        Scheduler$DisposeTask task = new Scheduler$DisposeTask(decoratedRun, w2);
        w2.schedule(task, delay, unit);
        return task;
    }

    @NonNull
    public Disposable schedulePeriodicallyDirect(@NonNull Runnable run, long initialDelay, long period, @NonNull TimeUnit unit) {
        Runnable decoratedRun;
        Scheduler$PeriodicDirectTask periodicTask;
        Scheduler$Worker w2 = this.createWorker();
        Disposable d2 = w2.schedulePeriodically(periodicTask = new Scheduler$PeriodicDirectTask(decoratedRun = RxJavaPlugins.onSchedule(run), w2), initialDelay, period, unit);
        if (d2 == EmptyDisposable.INSTANCE) {
            return d2;
        }
        return periodicTask;
    }

    @NonNull
    public <S extends Scheduler> S when(@NonNull Function<Flowable<Flowable<Completable>>, Completable> combine) {
        return (S)new SchedulerWhen(combine, this);
    }
}

