/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex;

import io.reactivex.Scheduler$Worker$PeriodicTask;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;

public abstract class Scheduler$Worker
implements Disposable {
    @NonNull
    public Disposable schedule(@NonNull Runnable run) {
        return this.schedule(run, 0L, TimeUnit.NANOSECONDS);
    }

    @NonNull
    public abstract Disposable schedule(@NonNull Runnable var1, long var2, @NonNull TimeUnit var4);

    @NonNull
    public Disposable schedulePeriodically(@NonNull Runnable run, long initialDelay, long period, @NonNull TimeUnit unit) {
        SequentialDisposable first = new SequentialDisposable();
        SequentialDisposable sd2 = new SequentialDisposable(first);
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        long periodInNanoseconds = unit.toNanos(period);
        long firstNowNanoseconds = this.now(TimeUnit.NANOSECONDS);
        long firstStartInNanoseconds = firstNowNanoseconds + unit.toNanos(initialDelay);
        Disposable d2 = this.schedule(new Scheduler$Worker$PeriodicTask(this, firstStartInNanoseconds, decoratedRun, firstNowNanoseconds, sd2, periodInNanoseconds), initialDelay, unit);
        if (d2 == EmptyDisposable.INSTANCE) {
            return d2;
        }
        first.replace(d2);
        return sd2;
    }

    public long now(@NonNull TimeUnit unit) {
        return unit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }
}

