/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex;

import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.NotificationLite;

public final class Notification<T> {
    final Object value;
    static final Notification<Object> COMPLETE = new Notification(null);

    private Notification(Object value) {
        this.value = value;
    }

    public boolean isOnComplete() {
        return this.value == null;
    }

    public boolean isOnError() {
        return NotificationLite.isError(this.value);
    }

    public boolean isOnNext() {
        Object o2 = this.value;
        return o2 != null && !NotificationLite.isError(o2);
    }

    @Nullable
    public T getValue() {
        Object o2 = this.value;
        if (o2 != null && !NotificationLite.isError(o2)) {
            return (T)this.value;
        }
        return null;
    }

    @Nullable
    public Throwable getError() {
        Object o2 = this.value;
        if (NotificationLite.isError(o2)) {
            return NotificationLite.getError(o2);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Notification) {
            Notification n2 = (Notification)obj;
            return ObjectHelper.equals(this.value, n2.value);
        }
        return false;
    }

    public int hashCode() {
        Object o2 = this.value;
        return o2 != null ? o2.hashCode() : 0;
    }

    public String toString() {
        Object o2 = this.value;
        if (o2 == null) {
            return "OnCompleteNotification";
        }
        if (NotificationLite.isError(o2)) {
            return "OnErrorNotification[" + NotificationLite.getError(o2) + "]";
        }
        return "OnNextNotification[" + this.value + "]";
    }

    @NonNull
    public static <T> Notification<T> createOnNext(@NonNull T value) {
        ObjectHelper.requireNonNull(value, "value is null");
        return new Notification<T>(value);
    }

    @NonNull
    public static <T> Notification<T> createOnError(@NonNull Throwable error) {
        ObjectHelper.requireNonNull(error, "error is null");
        return new Notification<T>(NotificationLite.error(error));
    }

    @NonNull
    public static <T> Notification<T> createOnComplete() {
        return COMPLETE;
    }
}

