/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.win.keyboard;

public enum KeyEventState {
    NORMAL(0, 0, 99, "\u9ed8\u8ba4\u8f93\u5165"),
    DIGITAL(1, 0, 99, "\u8f93\u5165\u7eaf\u6570\u5b57"),
    MONEY(2, 0, 10, "\u8f93\u5165\u91d1\u989d"),
    DISCOUNT(3, 0, 2, "\u8f93\u5165\u6298\u6263\u7387"),
    TABLE_NUM(4, 0, 4, "\u8f93\u5165\u684c\u724c\u53f7"),
    SCAN_NUM(5, 16, 24, "\u8f93\u5165\u4ed8\u6b3e\u7801"),
    COUPON_NUM(6, 0, 16, "\u8f93\u5165\u56e2\u8d2d\u5238\u7801");

    private int state;
    private int limitDigit;
    private int min;
    private String desc;

    private KeyEventState(int state, int min, int limitDigit, String desc) {
        this.state = state;
        this.min = min;
        this.limitDigit = limitDigit;
        this.desc = desc;
    }

    public KeyEventState getKeyState(int state) {
        for (KeyEventState value : KeyEventState.values()) {
            if (value.getState() != state) continue;
            return value;
        }
        return NORMAL;
    }

    public static boolean inputCheck(KeyEventState state, int len) {
        return len >= state.min && len <= state.limitDigit;
    }

    public int getState() {
        return this.state;
    }

    public int getLimitDigit() {
        return this.limitDigit;
    }

    public int getMin() {
        return this.min;
    }

    public String getDesc() {
        return this.desc;
    }
}

