/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.utils;

import android.support.annotation.NonNull;
import com.sankuai.waimai.router.components.RouterComponents;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.service.IFactory;
import java.util.HashMap;
import java.util.Map;

public class SingletonPool {
    private static final Map<Class, Object> CACHE = new HashMap<Class, Object>();

    private SingletonPool() {
    }

    public static <I, T extends I> T get(Class<I> clazz, IFactory factory) {
        if (clazz == null) {
            return null;
        }
        if (factory == null) {
            factory = RouterComponents.getDefaultFactory();
        }
        I instance = SingletonPool.getInstance(clazz, factory);
        Debugger.i("[SingletonPool]   get instance of class = %s, result = %s", clazz, instance);
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static <T> T getInstance(@NonNull Class<T> clazz, @NonNull IFactory factory) {
        Object t2 = CACHE.get(clazz);
        if (t2 != null) {
            return (T)t2;
        }
        Map<Class, Object> map = CACHE;
        synchronized (map) {
            t2 = CACHE.get(clazz);
            if (t2 == null) {
                Debugger.i("[SingletonPool] >>> create instance: %s", clazz);
                t2 = factory.create(clazz);
                CACHE.put(clazz, t2);
            }
        }
        return (T)t2;
    }
}

