/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.utils;

import android.support.annotation.NonNull;
import com.sankuai.waimai.router.utils.PriorityList$Node;
import com.sankuai.waimai.router.utils.PriorityList$NodeIterator;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class PriorityList<T>
extends AbstractList<T> {
    private final LinkedList<PriorityList$Node<T>> mList = new LinkedList();
    private final int mDefaultPriority;

    public PriorityList(int defaultPriority) {
        this.mDefaultPriority = defaultPriority;
    }

    public PriorityList() {
        this(0);
    }

    public boolean addItem(T item, int priority) {
        if (item == null) {
            return false;
        }
        PriorityList$Node<T> node = new PriorityList$Node<T>(item, priority);
        if (this.mList.isEmpty()) {
            this.mList.add(node);
            return true;
        }
        ListIterator<PriorityList$Node<T>> iterator = this.mList.listIterator();
        while (iterator.hasNext()) {
            PriorityList$Node next = (PriorityList$Node)iterator.next();
            if (next.priority >= priority) continue;
            iterator.previous();
            iterator.add(node);
            return true;
        }
        this.mList.addLast(node);
        return true;
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u6dfb\u52a0\u5230\u6307\u5b9a\u4f4d\u7f6e");
    }

    public boolean addItem(T item) {
        return this.addItem(item, this.mDefaultPriority);
    }

    @Override
    public boolean add(T item) {
        return this.addItem(item, this.mDefaultPriority);
    }

    @Override
    public boolean remove(Object item) {
        Iterator iterator = this.mList.iterator();
        while (iterator.hasNext()) {
            PriorityList$Node node = (PriorityList$Node)iterator.next();
            if (node.data != item) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.mList.size();
    }

    @Override
    public T get(int index) {
        return this.mList.get((int)index).data;
    }

    public int getPriory(int index) {
        return this.mList.get((int)index).priority;
    }

    @Override
    public T set(int index, T element) {
        PriorityList$Node<T> node = this.mList.get(index);
        Object t2 = node.data;
        node.data = element;
        return t2;
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        return new PriorityList$NodeIterator(this);
    }

    static /* synthetic */ LinkedList access$000(PriorityList x0) {
        return x0.mList;
    }
}

