/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.utils;

import com.sankuai.waimai.router.core.Debugger;

public abstract class LazyInitHelper {
    private final String mTag;
    private boolean mHasInit = false;

    public LazyInitHelper(String tag) {
        this.mTag = tag;
    }

    public void lazyInit() {
        this.performInit();
    }

    public void ensureInit() {
        this.performInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInit() {
        if (!this.mHasInit) {
            LazyInitHelper lazyInitHelper = this;
            synchronized (lazyInitHelper) {
                if (!this.mHasInit) {
                    this.mHasInit = true;
                    long ts2 = 0L;
                    boolean enableLog = Debugger.isEnableLog();
                    if (enableLog) {
                        ts2 = B.a();
                    }
                    try {
                        this.doInit();
                    }
                    catch (Throwable t2) {
                        Debugger.fatal(t2);
                    }
                    if (enableLog) {
                        Debugger.i("%s init cost %s ms", this.mTag, B.a() - ts2);
                    }
                }
            }
        }
    }

    protected abstract void doInit();
}

