/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.core;

import android.support.annotation.NonNull;
import com.sankuai.waimai.router.core.ChainedInterceptor$1;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.UriCallback;
import com.sankuai.waimai.router.core.UriInterceptor;
import com.sankuai.waimai.router.core.UriRequest;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ChainedInterceptor
implements UriInterceptor {
    private final List<UriInterceptor> mInterceptors = new LinkedList<UriInterceptor>();

    public void addInterceptor(UriInterceptor interceptor) {
        if (interceptor != null) {
            this.mInterceptors.add(interceptor);
        }
    }

    @Override
    public void intercept(@NonNull UriRequest request, @NonNull UriCallback callback) {
        this.next(this.mInterceptors.iterator(), request, callback);
    }

    private void next(@NonNull Iterator<UriInterceptor> iterator, @NonNull UriRequest request, @NonNull UriCallback callback) {
        if (iterator.hasNext()) {
            UriInterceptor t2 = iterator.next();
            if (Debugger.isEnableLog()) {
                Debugger.i("    %s: intercept, request = %s", t2.getClass().getSimpleName(), request);
            }
            t2.intercept(request, new ChainedInterceptor$1(this, iterator, request, callback));
        } else {
            callback.onNext();
        }
    }

    static /* synthetic */ void access$000(ChainedInterceptor x0, Iterator x1, UriRequest x2, UriCallback x3) {
        x0.next(x1, x2, x3);
    }
}

