/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.components;

import com.sankuai.waimai.router.activity.ActivityClassNameHandler;
import com.sankuai.waimai.router.activity.ActivityHandler;
import com.sankuai.waimai.router.common.NotExportedInterceptor;
import com.sankuai.waimai.router.core.UriHandler;
import com.sankuai.waimai.router.core.UriInterceptor;
import java.lang.reflect.Modifier;

public class UriTargetTools {
    private UriTargetTools() {
    }

    public static UriHandler parse(Object target, boolean exported, UriInterceptor ... interceptors) {
        UriHandler handler = UriTargetTools.toHandler(target);
        if (handler != null) {
            if (!exported) {
                handler.addInterceptor(NotExportedInterceptor.INSTANCE);
            }
            handler.addInterceptors(interceptors);
        }
        return handler;
    }

    private static UriHandler toHandler(Object target) {
        if (target instanceof UriHandler) {
            return (UriHandler)target;
        }
        if (target instanceof String) {
            return new ActivityClassNameHandler((String)target);
        }
        if (target instanceof Class && UriTargetTools.isValidActivityClass((Class)target)) {
            return new ActivityHandler((Class)target);
        }
        return null;
    }

    private static boolean isValidActivityClass(Class<?> clazz) {
        return clazz != null && a.class.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers());
    }
}

