/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.components;

import android.support.annotation.NonNull;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.UriRequest;

public class UriSourceTools {
    public static final int FROM_INVALID = 0;
    public static final int FROM_EXTERNAL = 1;
    public static final int FROM_INTERNAL = 2;
    public static final int FROM_WEBVIEW = 3;
    public static final int FROM_PUSH = 4;
    public static final String FIELD_FROM = "com.sankuai.waimai.router.from";
    public static final String INTENT_KEY_URI_FROM = "com.sankuai.waimai.router.from";
    private static boolean sDisableExportedControl = false;

    private UriSourceTools() {
    }

    public static void setDisableExportedControl(boolean disableExportedControl) {
        sDisableExportedControl = disableExportedControl;
    }

    public static boolean shouldHandle(UriRequest request, boolean exported) {
        return sDisableExportedControl || exported || UriSourceTools.getSource(request) != 1;
    }

    public static void setSource(UriRequest request, int from) {
        if (request != null) {
            request.putField("com.sankuai.waimai.router.from", from);
        }
    }

    public static int getSource(@NonNull UriRequest request) {
        return UriSourceTools.getSource(request, 2);
    }

    public static int getSource(@NonNull UriRequest request, int defaultValue) {
        return request.getIntField("com.sankuai.waimai.router.from", defaultValue);
    }

    public static void setIntentSource(g intent, UriRequest request) {
        Integer result;
        if (intent != null && request != null && (result = request.getField(Integer.class, "com.sankuai.waimai.router.from")) != null) {
            UriSourceTools.setSource(intent, (int)result);
        }
    }

    public static void setSource(g intent, int source) {
        if (intent != null) {
            intent.a("com.sankuai.waimai.router.from", source);
        }
    }

    public static int getSource(g intent, int defaultValue) {
        return UriSourceTools.getInt(intent, "com.sankuai.waimai.router.from", defaultValue);
    }

    public static int getSource(A bundle, int defaultValue) {
        return bundle == null ? defaultValue : bundle.a("com.sankuai.waimai.router.from", defaultValue);
    }

    private static int getInt(g intent, String key, int defaultValue) {
        if (intent == null) {
            return defaultValue;
        }
        try {
            return intent.a(key, defaultValue);
        }
        catch (Exception e2) {
            Debugger.fatal(e2);
            return defaultValue;
        }
    }
}

