/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.components;

import android.support.annotation.NonNull;
import com.sankuai.waimai.router.components.ActivityLauncher;
import com.sankuai.waimai.router.components.AnnotationInit;
import com.sankuai.waimai.router.components.AnnotationLoader;
import com.sankuai.waimai.router.components.DefaultActivityLauncher;
import com.sankuai.waimai.router.components.DefaultAnnotationLoader;
import com.sankuai.waimai.router.core.UriHandler;
import com.sankuai.waimai.router.core.UriRequest;
import com.sankuai.waimai.router.service.DefaultFactory;
import com.sankuai.waimai.router.service.IFactory;

public class RouterComponents {
    @NonNull
    private static AnnotationLoader sAnnotationLoader = DefaultAnnotationLoader.INSTANCE;
    @NonNull
    private static ActivityLauncher sActivityLauncher = DefaultActivityLauncher.INSTANCE;
    @NonNull
    private static IFactory sDefaultFactory = DefaultFactory.INSTANCE;

    private RouterComponents() {
    }

    public static void setAnnotationLoader(AnnotationLoader loader) {
        sAnnotationLoader = loader == null ? DefaultAnnotationLoader.INSTANCE : loader;
    }

    public static void setActivityLauncher(ActivityLauncher launcher) {
        sActivityLauncher = launcher == null ? DefaultActivityLauncher.INSTANCE : launcher;
    }

    public static void setDefaultFactory(IFactory factory) {
        sDefaultFactory = factory == null ? DefaultFactory.INSTANCE : factory;
    }

    @NonNull
    public static IFactory getDefaultFactory() {
        return sDefaultFactory;
    }

    public static <T extends UriHandler> void loadAnnotation(T handler, Class<? extends AnnotationInit<T>> initClass) {
        sAnnotationLoader.load(handler, initClass);
    }

    public static int startActivity(@NonNull UriRequest request, @NonNull g intent) {
        return sActivityLauncher.startActivity(request, intent);
    }
}

