/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.common;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.sankuai.waimai.router.common.IUriAnnotationInit;
import com.sankuai.waimai.router.common.NotFoundHandler;
import com.sankuai.waimai.router.common.PathHandler;
import com.sankuai.waimai.router.common.UriAnnotationHandler$1;
import com.sankuai.waimai.router.components.RouterComponents;
import com.sankuai.waimai.router.core.UriCallback;
import com.sankuai.waimai.router.core.UriHandler;
import com.sankuai.waimai.router.core.UriInterceptor;
import com.sankuai.waimai.router.core.UriRequest;
import com.sankuai.waimai.router.utils.LazyInitHelper;
import com.sankuai.waimai.router.utils.RouterUtils;
import java.util.HashMap;
import java.util.Map;

public class UriAnnotationHandler
extends UriHandler {
    private static boolean sAddNotFoundHandler = true;
    private final Map<String, PathHandler> mMap = new HashMap<String, PathHandler>();
    private final String mDefaultScheme;
    private final String mDefaultHost;
    private final LazyInitHelper mInitHelper = new UriAnnotationHandler$1(this, "UriAnnotationHandler");

    public static void setAddNotFoundHandler(boolean addNotFoundHandler) {
        sAddNotFoundHandler = addNotFoundHandler;
    }

    public UriAnnotationHandler(@Nullable String defaultScheme, @Nullable String defaultHost) {
        this.mDefaultScheme = RouterUtils.toNonNullString(defaultScheme);
        this.mDefaultHost = RouterUtils.toNonNullString(defaultHost);
    }

    public void lazyInit() {
        this.mInitHelper.lazyInit();
    }

    protected void initAnnotationConfig() {
        RouterComponents.loadAnnotation(this, IUriAnnotationInit.class);
    }

    public PathHandler getPathHandler(String scheme, String host) {
        return this.mMap.get(RouterUtils.schemeHost(scheme, host));
    }

    public void setPathPrefix(String scheme, String host, String prefix) {
        PathHandler pathHandler = this.getPathHandler(scheme, host);
        if (pathHandler != null) {
            pathHandler.setPathPrefix(prefix);
        }
    }

    public void setPathPrefix(String prefix) {
        for (PathHandler pathHandler : this.mMap.values()) {
            pathHandler.setPathPrefix(prefix);
        }
    }

    public void register(String scheme, String host, String path, Object handler, boolean exported, UriInterceptor ... interceptors) {
        String schemeHost;
        PathHandler pathHandler;
        if (F.a(scheme)) {
            scheme = this.mDefaultScheme;
        }
        if (F.a(host)) {
            host = this.mDefaultHost;
        }
        if ((pathHandler = this.mMap.get(schemeHost = RouterUtils.schemeHost(scheme, host))) == null) {
            pathHandler = this.createPathHandler();
            this.mMap.put(schemeHost, pathHandler);
        }
        pathHandler.register(path, handler, exported, interceptors);
    }

    @NonNull
    protected PathHandler createPathHandler() {
        PathHandler pathHandler = new PathHandler();
        if (sAddNotFoundHandler) {
            pathHandler.setDefaultChildHandler(NotFoundHandler.INSTANCE);
        }
        return pathHandler;
    }

    private PathHandler getChild(@NonNull UriRequest request) {
        return this.mMap.get(request.schemeHost());
    }

    @Override
    public void handle(@NonNull UriRequest request, @NonNull UriCallback callback) {
        this.mInitHelper.ensureInit();
        super.handle(request, callback);
    }

    @Override
    public boolean shouldHandle(@NonNull UriRequest request) {
        return this.getChild(request) != null;
    }

    @Override
    public void handleInternal(@NonNull UriRequest request, @NonNull UriCallback callback) {
        PathHandler pathHandler = this.getChild(request);
        if (pathHandler != null) {
            pathHandler.handle(request, callback);
        } else {
            callback.onNext();
        }
    }

    @Override
    public String toString() {
        return "UriAnnotationHandler";
    }
}

