/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.common;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.sankuai.waimai.router.common.PageAnnotationHandler;
import com.sankuai.waimai.router.common.StartUriHandler;
import com.sankuai.waimai.router.common.UriAnnotationHandler;
import com.sankuai.waimai.router.components.DefaultOnCompleteListener;
import com.sankuai.waimai.router.core.RootUriHandler;
import com.sankuai.waimai.router.regex.RegexAnnotationHandler;

public class DefaultRootUriHandler
extends RootUriHandler {
    private final PageAnnotationHandler mPageAnnotationHandler = this.createPageAnnotationHandler();
    private final UriAnnotationHandler mUriAnnotationHandler;
    private final RegexAnnotationHandler mRegexAnnotationHandler;

    public DefaultRootUriHandler(f context) {
        this(context, null, null);
    }

    public DefaultRootUriHandler(f context, @Nullable String defaultScheme, @Nullable String defaultHost) {
        super(context);
        this.mUriAnnotationHandler = this.createUriAnnotationHandler(defaultScheme, defaultHost);
        this.mRegexAnnotationHandler = this.createRegexAnnotationHandler();
        this.addChildHandler(this.mPageAnnotationHandler, 300);
        this.addChildHandler(this.mUriAnnotationHandler, 200);
        this.addChildHandler(this.mRegexAnnotationHandler, 100);
        this.addChildHandler(new StartUriHandler(), -100);
        this.setGlobalOnCompleteListener(DefaultOnCompleteListener.INSTANCE);
    }

    @Override
    public void lazyInit() {
        this.mPageAnnotationHandler.lazyInit();
        this.mUriAnnotationHandler.lazyInit();
        this.mRegexAnnotationHandler.lazyInit();
    }

    public PageAnnotationHandler getPageAnnotationHandler() {
        return this.mPageAnnotationHandler;
    }

    public UriAnnotationHandler getUriAnnotationHandler() {
        return this.mUriAnnotationHandler;
    }

    public RegexAnnotationHandler getRegexAnnotationHandler() {
        return this.mRegexAnnotationHandler;
    }

    @NonNull
    protected PageAnnotationHandler createPageAnnotationHandler() {
        return new PageAnnotationHandler();
    }

    @NonNull
    protected UriAnnotationHandler createUriAnnotationHandler(@Nullable String defaultScheme, @Nullable String defaultHost) {
        return new UriAnnotationHandler(defaultScheme, defaultHost);
    }

    @NonNull
    protected RegexAnnotationHandler createRegexAnnotationHandler() {
        return new RegexAnnotationHandler();
    }
}

