/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.ng.common.time.win.timetools;

import com.sankuai.ng.common.time.win.timetools.RecycleArray;
import com.sankuai.ng.common.time.win.timetools.Tools;

public class TimeChecker {
    public static final long PERIOD = 120000L;
    public static final int PERIOD_MAX_COUNT = 3;
    private RecycleArray<Long> mRecycleTimeArray = null;
    private long mTimePeroid;
    private int mMaxCheckCount;

    public TimeChecker() {
        this.initTimeChecker(120000L, 3);
    }

    public TimeChecker(long period, int peroidMaxCount) {
        this.initTimeChecker(period, peroidMaxCount);
    }

    private void initTimeChecker(long period, int periodMaxCount) {
        this.mRecycleTimeArray = new RecycleArray(periodMaxCount);
        this.mTimePeroid = period;
        this.mMaxCheckCount = periodMaxCount;
    }

    public boolean isTooFrequently(long checkTime) {
        boolean tooFrequently = false;
        if (this.mRecycleTimeArray != null && !this.mRecycleTimeArray.isEmpty() && this.mRecycleTimeArray.isFull()) {
            long time = Tools.getDiffMillsTime(checkTime, this.mRecycleTimeArray.getHeader());
            boolean bl2 = tooFrequently = time <= this.mTimePeroid;
        }
        if (!tooFrequently) {
            this.mRecycleTimeArray.addLast(checkTime);
        }
        return tooFrequently;
    }

    public long getPeroid() {
        return this.mTimePeroid;
    }

    public long getMaxCount() {
        return this.mMaxCheckCount;
    }
}

