/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.ng.common.time.win;

import com.google.gson.Gson;
import com.sankuai.ng.common.log.LogLevel;
import com.sankuai.ng.common.time.win.SntpClock$1;
import com.sankuai.ng.common.time.win.timetools.ElapseTimeSync;
import com.sankuai.ng.common.time.win.timetools.TimeChecker;
import com.sankuai.ng.common.time.win.timetools.Tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

public class SntpClock {
    private static ui logger;
    private static long offset;
    private static aE sharkService;
    private static volatile boolean init;
    private static Gson gson;
    private static final String pingUrl = "http://apimobile.meituan.com/group/v1/timestamp/milliseconds";
    private static String TAG;
    private static int TIMEOUT_LIMIT;
    private static final long ERROR_TIME_TAG = Long.MIN_VALUE;
    private static ElapseTimeSync sElapseTimeSync;
    private static final long MAX_DIFF_TIME = 10000L;
    private static TimeChecker mTimeChecker;

    public static void init(ui logger, aE sharkService) {
        SntpClock.logger = logger;
        SntpClock.sharkService = sharkService;
        init = true;
    }

    public static synchronized void sync() {
        if (!init) {
            logger.a(LogLevel.ERROR, TAG, "cannot sync before init");
            return;
        }
        long curTime = System.currentTimeMillis();
        long remoteTime = sharkService == null ? SntpClock.getRemoteTimeByHttp(Long.MIN_VALUE) : SntpClock.getRemoteTimeByShark(Long.MIN_VALUE);
        if (remoteTime == Long.MIN_VALUE) {
            offset = 0L;
        } else {
            sElapseTimeSync.syncTime(remoteTime);
            offset = remoteTime - curTime;
        }
        logger.a(LogLevel.INFO, TAG, "remoteTime= " + remoteTime + " curTime=" + curTime + " offset = " + offset);
    }

    private static long getRemoteTimeByShark(long remoteTime) {
        try {
            au request = new av().a(pingUrl).a();
            ay resp = sharkService.a(request);
            if (resp == null || resp.a() == null || resp.a().length == 0) {
                logger.a(LogLevel.INFO, TAG, "get remote time response is null ");
                return SntpClock.getRemoteTimeByHttp(remoteTime);
            }
            logger.a(LogLevel.INFO, TAG, "get remote time response body " + new String(resp.a()));
            return SntpClock.parseRemoteTime(new String(resp.a()), remoteTime);
        }
        catch (Exception e2) {
            logger.a(LogLevel.ERROR, TAG, "get remote time by shark error", e2);
            return SntpClock.getRemoteTimeByHttp(remoteTime);
        }
    }

    private static long getRemoteTimeByHttp(long remoteTime) {
        try {
            String response = SntpClock.connectMeituanServer(pingUrl);
            logger.a(LogLevel.INFO, TAG, "get remote time response " + response);
            if (wc.a((CharSequence)response)) {
                return remoteTime;
            }
            return SntpClock.parseRemoteTime(response, remoteTime);
        }
        catch (Exception e2) {
            logger.a(LogLevel.ERROR, TAG, "get remote time by http error", e2);
            return remoteTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String connectMeituanServer(String url) {
        String result = "";
        BufferedReader in2 = null;
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setReadTimeout(TIMEOUT_LIMIT);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.connect();
            in2 = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in2.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (in2 != null) {
                    in2.close();
                }
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
        return result;
    }

    private static long parseRemoteTime(String resp, long remoteTime) {
        Map responseMap = (Map)gson.a(resp, new SntpClock$1().getType());
        if (!responseMap.containsKey("currentMs")) {
            return remoteTime;
        }
        return Long.parseLong((String)responseMap.get("currentMs"));
    }

    public static long currentTimeMillis() {
        if (!sElapseTimeSync.isSync()) {
            SntpClock.autoSync();
        } else {
            long expectedSystemTime;
            long actualTime = sElapseTimeSync.getCurrentTime();
            if (Math.abs(actualTime - (expectedSystemTime = System.currentTimeMillis() + offset)) > 10000L) {
                logger.a(LogLevel.WARN, TAG, "mistake is too large, sync time for actualTime:" + actualTime + ", syncTime:" + expectedSystemTime);
                SntpClock.autoSync();
            }
        }
        return sElapseTimeSync.getCurrentTime();
    }

    private static void autoSync() {
        if (mTimeChecker.isTooFrequently(Tools.getNanoTime())) {
            logger.a(LogLevel.INFO, TAG, "sync times too much, wait for a moment.");
            return;
        }
        SntpClock.sync();
    }

    static {
        init = false;
        gson = new Gson();
        TAG = "SntpClock";
        TIMEOUT_LIMIT = 60000;
        sElapseTimeSync = new ElapseTimeSync();
        mTimeChecker = new TimeChecker();
    }
}

