/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JsonWriter
implements Closeable,
Flushable {
    private static final String[] a = new String[128];
    private static final String[] b;
    private final Writer a;
    private int[] a;
    private int a;
    private String a;
    private String b;
    private boolean a = 0;
    private boolean b;
    private String c;
    private boolean c;

    public JsonWriter(Writer out) {
        this.a(6);
        this.b = ":";
        this.c = true;
        if (out == null) {
            throw new NullPointerException("out == null");
        }
        this.a = out;
    }

    public final void a(String indent) {
        if (indent.length() == 0) {
            this.a = null;
            this.b = ":";
        } else {
            this.a = indent;
            this.b = ": ";
        }
    }

    public final void a(boolean lenient) {
        this.a = lenient;
    }

    public boolean a() {
        return this.a;
    }

    public final void b(boolean htmlSafe) {
        this.b = htmlSafe;
    }

    public final boolean b() {
        return this.b;
    }

    public final void c(boolean serializeNulls) {
        this.c = serializeNulls;
    }

    public final boolean c() {
        return this.c;
    }

    public JsonWriter a() {
        this.a();
        return this.a(1, "[");
    }

    public JsonWriter b() {
        return this.a(1, 2, "]");
    }

    public JsonWriter c() {
        this.a();
        return this.a(3, "{");
    }

    public JsonWriter d() {
        return this.a(3, 5, "}");
    }

    private JsonWriter a(int empty, String openBracket) {
        this.d();
        this.a(empty);
        this.a.write(openBracket);
        return this;
    }

    private JsonWriter a(int empty, int nonempty, String closeBracket) {
        int context = this.a();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.c != null) {
            throw new IllegalStateException("Dangling name: " + this.c);
        }
        --this.a;
        if (context == nonempty) {
            this.b();
        }
        this.a.write(closeBracket);
        return this;
    }

    private void a(int newTop) {
        if (this.a == this.a.length) {
            int[] newStack = new int[this.a * 2];
            System.arraycopy(this.a, 0, newStack, 0, this.a);
            this.a = newStack;
        }
        this.a[this.a++] = newTop;
    }

    private int a() {
        if (this.a == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.a[this.a - 1];
    }

    private void b(int topOfStack) {
        this.a[this.a - 1] = topOfStack;
    }

    public JsonWriter a(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.c != null) {
            throw new IllegalStateException();
        }
        if (this.a == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.c = name;
        return this;
    }

    private void a() {
        if (this.c != null) {
            this.c();
            this.b(this.c);
            this.c = null;
        }
    }

    public JsonWriter b(String value) {
        if (value == null) {
            return this.e();
        }
        this.a();
        this.d();
        this.b(value);
        return this;
    }

    public JsonWriter e() {
        if (this.c != null) {
            if (this.c) {
                this.a();
            } else {
                this.c = null;
                return this;
            }
        }
        this.d();
        this.a.write("null");
        return this;
    }

    public JsonWriter a(boolean value) {
        this.a();
        this.d();
        this.a.write(value ? "true" : "false");
        return this;
    }

    public JsonWriter a(Boolean value) {
        if (value == null) {
            return this.e();
        }
        this.a();
        this.d();
        this.a.write(value != false ? "true" : "false");
        return this;
    }

    public JsonWriter a(long value) {
        this.a();
        this.d();
        this.a.write(Long.toString(value));
        return this;
    }

    public JsonWriter a(Number value) {
        if (value == null) {
            return this.e();
        }
        this.a();
        String string = value.toString();
        if (!this.a && (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.d();
        this.a.append(string);
        return this;
    }

    @Override
    public void flush() {
        if (this.a == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.a.flush();
    }

    @Override
    public void close() {
        this.a.close();
        int size = this.a;
        if (size > 1 || size == 1 && this.a[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.a = 0;
    }

    private void b(String value) {
        String[] replacements = this.b ? b : a;
        this.a.write("\"");
        int last = 0;
        int length = value.length();
        for (int i2 = 0; i2 < length; ++i2) {
            String replacement;
            char c2 = value.charAt(i2);
            if (c2 < '\u0080') {
                replacement = replacements[c2];
                if (replacement == null) {
                    continue;
                }
            } else if (c2 == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c2 != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i2) {
                this.a.write(value, last, i2 - last);
            }
            this.a.write(replacement);
            last = i2 + 1;
        }
        if (last < length) {
            this.a.write(value, last, length - last);
        }
        this.a.write("\"");
    }

    private void b() {
        if (this.a == null) {
            return;
        }
        this.a.write("\n");
        int size = this.a;
        for (int i2 = 1; i2 < size; ++i2) {
            this.a.write(this.a);
        }
    }

    private void c() {
        int context = this.a();
        if (context == 5) {
            this.a.write(44);
        } else if (context != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.b();
        this.b(4);
    }

    private void d() {
        switch (this.a()) {
            case 7: {
                if (!this.a) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                this.b(7);
                break;
            }
            case 1: {
                this.b(2);
                this.b();
                break;
            }
            case 2: {
                this.a.append(',');
                this.b();
                break;
            }
            case 4: {
                this.a.append(this.b);
                this.b(5);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
        }
    }

    static {
        for (int i2 = 0; i2 <= 31; ++i2) {
            JsonWriter.a[i2] = String.format("\\u%04x", i2);
        }
        JsonWriter.a[34] = "\\\"";
        JsonWriter.a[92] = "\\\\";
        JsonWriter.a[9] = "\\t";
        JsonWriter.a[8] = "\\b";
        JsonWriter.a[10] = "\\n";
        JsonWriter.a[13] = "\\r";
        JsonWriter.a[12] = "\\f";
        b = (String[])a.clone();
        JsonWriter.b[60] = "\\u003c";
        JsonWriter.b[62] = "\\u003e";
        JsonWriter.b[38] = "\\u0026";
        JsonWriter.b[61] = "\\u003d";
        JsonWriter.b[39] = "\\u0027";
    }
}

