/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ISO8601Utils {
    private static final TimeZone a = TimeZone.getTimeZone("UTC");

    public static Date a(String date, ParsePosition pos) {
        RuntimeException fail = null;
        try {
            int offset = pos.getIndex();
            int year = ISO8601Utils.a(date, offset, offset += 4);
            if (ISO8601Utils.a(date, offset, '-')) {
                // empty if block
            }
            int month = ISO8601Utils.a(date, ++offset, offset += 2);
            if (ISO8601Utils.a(date, offset, '-')) {
                // empty if block
            }
            int day = ISO8601Utils.a(date, ++offset, offset += 2);
            int hour = 0;
            int minutes = 0;
            int seconds = 0;
            int milliseconds = 0;
            boolean hasT = ISO8601Utils.a(date, offset, 'T');
            if (!hasT && date.length() <= offset) {
                GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
                pos.setIndex(offset);
                return calendar.getTime();
            }
            if (hasT) {
                char c2;
                hour = ISO8601Utils.a(date, ++offset, offset += 2);
                if (ISO8601Utils.a(date, offset, ':')) {
                    // empty if block
                }
                minutes = ISO8601Utils.a(date, ++offset, offset += 2);
                if (ISO8601Utils.a(date, offset, ':')) {
                    ++offset;
                }
                if (date.length() > offset && (c2 = date.charAt(offset)) != 'Z' && c2 != '+' && c2 != '-') {
                    if ((seconds = ISO8601Utils.a(date, offset, offset += 2)) > 59 && seconds < 63) {
                        seconds = 59;
                    }
                    if (ISO8601Utils.a(date, offset, '.')) {
                        int endOffset = ISO8601Utils.a(date, ++offset + 1);
                        int parseEndOffset = Math.min(endOffset, offset + 3);
                        int fraction = ISO8601Utils.a(date, offset, parseEndOffset);
                        switch (parseEndOffset - offset) {
                            case 2: {
                                milliseconds = fraction * 10;
                                break;
                            }
                            case 1: {
                                milliseconds = fraction * 100;
                                break;
                            }
                            default: {
                                milliseconds = fraction;
                            }
                        }
                        offset = endOffset;
                    }
                }
            }
            if (date.length() <= offset) {
                throw new IllegalArgumentException("No time zone indicator");
            }
            TimeZone timezone = null;
            char timezoneIndicator = date.charAt(offset);
            if (timezoneIndicator == 'Z') {
                timezone = a;
                ++offset;
            } else if (timezoneIndicator == '+' || timezoneIndicator == '-') {
                String timezoneOffset = date.substring(offset);
                timezoneOffset = timezoneOffset.length() >= 5 ? timezoneOffset : timezoneOffset + "00";
                offset += timezoneOffset.length();
                if ("+0000".equals(timezoneOffset) || "+00:00".equals(timezoneOffset)) {
                    timezone = a;
                } else {
                    String cleaned;
                    String timezoneId = "GMT" + timezoneOffset;
                    timezone = TimeZone.getTimeZone(timezoneId);
                    String act = timezone.getID();
                    if (!act.equals(timezoneId) && !(cleaned = act.replace(":", "")).equals(timezoneId)) {
                        throw new IndexOutOfBoundsException("Mismatching time zone indicator: " + timezoneId + " given, resolves to " + timezone.getID());
                    }
                }
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator '" + timezoneIndicator + "'");
            }
            GregorianCalendar calendar = new GregorianCalendar(timezone);
            calendar.setLenient(false);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            calendar.set(14, milliseconds);
            pos.setIndex(offset);
            return calendar.getTime();
        }
        catch (IndexOutOfBoundsException e2) {
            fail = e2;
        }
        catch (NumberFormatException e3) {
            fail = e3;
        }
        catch (IllegalArgumentException e4) {
            fail = e4;
        }
        String input = date == null ? null : '\"' + date + '\"';
        String msg = fail.getMessage();
        if (msg == null || msg.isEmpty()) {
            msg = "(" + fail.getClass().getName() + ")";
        }
        ParseException ex2 = new ParseException("Failed to parse date [" + input + "]: " + msg, pos.getIndex());
        ex2.initCause(fail);
        throw ex2;
    }

    private static boolean a(String value, int offset, char expected) {
        return offset < value.length() && value.charAt(offset) == expected;
    }

    private static int a(String value, int beginIndex, int endIndex) {
        int digit;
        if (beginIndex < 0 || endIndex > value.length() || beginIndex > endIndex) {
            throw new NumberFormatException(value);
        }
        int i2 = beginIndex;
        int result = 0;
        if (i2 < endIndex) {
            if ((digit = Character.digit(value.charAt(i2++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value.substring(beginIndex, endIndex));
            }
            result = -digit;
        }
        while (i2 < endIndex) {
            if ((digit = Character.digit(value.charAt(i2++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value.substring(beginIndex, endIndex));
            }
            result *= 10;
            result -= digit;
        }
        return -result;
    }

    private static int a(String string, int offset) {
        for (int i2 = offset; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') continue;
            return i2;
        }
        return string.length();
    }
}

