/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
final class MapTypeAdapterFactory$Adapter<K, V>
extends TypeAdapter<Map<K, V>> {
    private final TypeAdapter<K> a;
    private final TypeAdapter<V> b;
    private final ObjectConstructor<? extends Map<K, V>> a;
    final /* synthetic */ MapTypeAdapterFactory a;

    public MapTypeAdapterFactory$Adapter(MapTypeAdapterFactory mapTypeAdapterFactory, Gson context, Type keyType, TypeAdapter<K> keyTypeAdapter, Type valueType, TypeAdapter<V> valueTypeAdapter, ObjectConstructor<? extends Map<K, V>> constructor) {
        this.a = mapTypeAdapterFactory;
        this.a = new TypeAdapterRuntimeTypeWrapper<K>(context, keyTypeAdapter, keyType);
        this.b = new TypeAdapterRuntimeTypeWrapper<V>(context, valueTypeAdapter, valueType);
        this.a = constructor;
    }

    @Override
    public Map<K, V> a(JsonReader in2) {
        JsonToken peek = in2.a();
        if (peek == JsonToken.NULL) {
            in2.e();
            return null;
        }
        Map map = (Map)this.a.a();
        if (peek == JsonToken.BEGIN_ARRAY) {
            in2.a();
            while (in2.a()) {
                in2.a();
                K key = this.a.a(in2);
                V value = this.b.a(in2);
                V replaced = map.put(key, value);
                if (replaced != null) {
                    throw new JsonSyntaxException("duplicate key: " + key);
                }
                in2.b();
            }
            in2.b();
        } else {
            in2.c();
            while (in2.a()) {
                V value;
                JsonReaderInternalAccess.a.a(in2);
                K key = this.a.a(in2);
                V replaced = map.put(key, value = this.b.a(in2));
                if (replaced == null) continue;
                throw new JsonSyntaxException("duplicate key: " + key);
            }
            in2.d();
        }
        return map;
    }

    @Override
    public void a(JsonWriter out, Map<K, V> map) {
        JsonElement keyElement;
        if (map == null) {
            out.e();
            return;
        }
        if (!this.a.a) {
            out.c();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                out.a(String.valueOf(entry.getKey()));
                this.b.a(out, entry.getValue());
            }
            out.d();
            return;
        }
        boolean hasComplexKeys = false;
        ArrayList<JsonElement> keys = new ArrayList<JsonElement>(map.size());
        ArrayList<V> values = new ArrayList<V>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keyElement = this.a.a(entry.getKey());
            keys.add(keyElement);
            values.add(entry.getValue());
            hasComplexKeys |= keyElement.b() || keyElement.c();
        }
        if (hasComplexKeys) {
            out.a();
            int size = keys.size();
            for (int i2 = 0; i2 < size; ++i2) {
                out.a();
                Streams.a((JsonElement)keys.get(i2), out);
                this.b.a(out, values.get(i2));
                out.b();
            }
            out.b();
        } else {
            out.c();
            int size = keys.size();
            for (int i3 = 0; i3 < size; ++i3) {
                keyElement = (JsonElement)keys.get(i3);
                out.a(this.a(keyElement));
                this.b.a(out, values.get(i3));
            }
            out.d();
        }
    }

    private String a(JsonElement keyElement) {
        if (keyElement.d()) {
            JsonPrimitive primitive = keyElement.a();
            if (primitive.g()) {
                return String.valueOf(primitive.a());
            }
            if (primitive.f()) {
                return Boolean.toString(primitive.a());
            }
            if (primitive.h()) {
                return primitive.a();
            }
            throw new AssertionError();
        }
        if (keyElement.e()) {
            return "null";
        }
        throw new AssertionError();
    }
}

