/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.JavaVersion;
import com.google.gson.internal.PreJava9DateFormatProvider;
import com.google.gson.internal.bind.DateTypeAdapter$1;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class DateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory a = new DateTypeAdapter$1();
    private final List<DateFormat> a = new ArrayList();

    public DateTypeAdapter() {
        this.a.add(DateFormat.getDateTimeInstance(2, 2, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.a.add(DateFormat.getDateTimeInstance(2, 2));
        }
        if (JavaVersion.a()) {
            this.a.add(PreJava9DateFormatProvider.a(2, 2));
        }
    }

    @Override
    public Date a(JsonReader in2) {
        if (in2.a() == JsonToken.NULL) {
            in2.e();
            return null;
        }
        return this.a(in2.b());
    }

    @Override
    private synchronized Date a(String json) {
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            DateFormat dateFormat = (DateFormat)iterator.next();
            try {
                return dateFormat.parse(json);
            }
            catch (ParseException parseException) {
            }
        }
        try {
            return ISO8601Utils.a(json, new ParsePosition(0));
        }
        catch (ParseException e2) {
            throw new JsonSyntaxException(json, e2);
        }
    }

    @Override
    public synchronized void a(JsonWriter out, Date value) {
        if (value == null) {
            out.e();
            return;
        }
        String dateFormatAsString = ((DateFormat)this.a.get(0)).format(value);
        out.b(dateFormatAsString);
    }
}

