/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.LinkedHashTreeMap$1;
import com.google.gson.internal.LinkedHashTreeMap$AvlBuilder;
import com.google.gson.internal.LinkedHashTreeMap$AvlIterator;
import com.google.gson.internal.LinkedHashTreeMap$EntrySet;
import com.google.gson.internal.LinkedHashTreeMap$KeySet;
import com.google.gson.internal.LinkedHashTreeMap$Node;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class LinkedHashTreeMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Comparator<Comparable> NATURAL_ORDER = new LinkedHashTreeMap$1();
    Comparator<? super K> comparator;
    LinkedHashTreeMap$Node<K, V>[] table;
    final LinkedHashTreeMap$Node<K, V> header;
    int size = 0;
    int modCount = 0;
    int threshold;
    private LinkedHashTreeMap$EntrySet entrySet;
    private LinkedHashTreeMap$KeySet keySet;

    public LinkedHashTreeMap() {
        this(NATURAL_ORDER);
    }

    public LinkedHashTreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator != null ? comparator : NATURAL_ORDER;
        this.header = new LinkedHashTreeMap$Node();
        this.table = new LinkedHashTreeMap$Node[16];
        this.threshold = this.table.length / 2 + this.table.length / 4;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(Object key) {
        LinkedHashTreeMap$Node<K, V> node = this.findByObject(key);
        return (V)(node != null ? node.b : null);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findByObject(key) != null;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LinkedHashTreeMap$Node<K, V> created = this.find(key, true);
        LinkedHashTreeMap$Node result = created.b;
        created.b = value;
        return (V)result;
    }

    @Override
    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
        ++this.modCount;
        LinkedHashTreeMap$Node<K, V> header = this.header;
        LinkedHashTreeMap$Node e2 = header.d;
        while (e2 != header) {
            LinkedHashTreeMap$Node next = e2.d;
            e2.e = null;
            e2.d = null;
            e2 = next;
        }
        header.e = header;
        header.d = header.e;
    }

    @Override
    public V remove(Object key) {
        LinkedHashTreeMap$Node<K, V> node = this.removeInternalByKey(key);
        return (V)(node != null ? node.b : null);
    }

    LinkedHashTreeMap$Node<K, V> find(K key, boolean create) {
        LinkedHashTreeMap$Node<K, V> created;
        Comparator<K> comparator = this.comparator;
        LinkedHashTreeMap$Node<K, V>[] table = this.table;
        int hash = LinkedHashTreeMap.secondaryHash(key.hashCode());
        int index = hash & table.length - 1;
        LinkedHashTreeMap$Node<K, V> nearest = table[index];
        int comparison = 0;
        if (nearest != null) {
            Comparable comparableKey = comparator == NATURAL_ORDER ? (Comparable)key : null;
            while (true) {
                LinkedHashTreeMap$Node child;
                int n2 = comparison = comparableKey != null ? comparableKey.compareTo(nearest.a) : comparator.compare(key, nearest.a);
                if (comparison == 0) {
                    return nearest;
                }
                LinkedHashTreeMap$Node linkedHashTreeMap$Node = child = comparison < 0 ? nearest.b : nearest.c;
                if (child == null) break;
                nearest = child;
            }
        }
        if (!create) {
            return null;
        }
        LinkedHashTreeMap$Node<K, V> header = this.header;
        if (nearest == null) {
            if (comparator == NATURAL_ORDER && !(key instanceof Comparable)) {
                throw new ClassCastException(key.getClass().getName() + " is not Comparable");
            }
            created = new LinkedHashTreeMap$Node<K, V>(nearest, key, hash, header, header.e);
            table[index] = created;
        } else {
            created = new LinkedHashTreeMap$Node<K, V>(nearest, key, hash, header, header.e);
            if (comparison < 0) {
                nearest.b = created;
            } else {
                nearest.c = created;
            }
            this.rebalance(nearest, true);
        }
        if (this.size++ > this.threshold) {
            this.doubleCapacity();
        }
        ++this.modCount;
        return created;
    }

    LinkedHashTreeMap$Node<K, V> findByObject(Object key) {
        try {
            return key != null ? this.find(key, false) : null;
        }
        catch (ClassCastException e2) {
            return null;
        }
    }

    LinkedHashTreeMap$Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        LinkedHashTreeMap$Node<K, V> mine = this.findByObject(entry.getKey());
        boolean valuesEqual = mine != null && this.equal(mine.b, entry.getValue());
        return valuesEqual ? mine : null;
    }

    private boolean equal(Object a2, Object b2) {
        return a2 == b2 || a2 != null && a2.equals(b2);
    }

    private static int secondaryHash(int h2) {
        h2 ^= h2 >>> 20 ^ h2 >>> 12;
        return h2 ^ h2 >>> 7 ^ h2 >>> 4;
    }

    void removeInternal(LinkedHashTreeMap$Node<K, V> node, boolean unlink) {
        if (unlink) {
            node.e.d = node.d;
            node.d.e = node.e;
            node.e = null;
            node.d = null;
        }
        LinkedHashTreeMap$Node left = node.b;
        LinkedHashTreeMap$Node right = node.c;
        LinkedHashTreeMap$Node originalParent = node.a;
        if (left != null && right != null) {
            LinkedHashTreeMap$Node adjacent = left.b > right.b ? left.b() : right.a();
            this.removeInternal(adjacent, false);
            int leftHeight = 0;
            left = node.b;
            if (left != null) {
                leftHeight = left.b;
                adjacent.b = left;
                left.a = adjacent;
                node.b = null;
            }
            int rightHeight = 0;
            right = node.c;
            if (right != null) {
                rightHeight = right.b;
                adjacent.c = right;
                right.a = adjacent;
                node.c = null;
            }
            adjacent.b = Math.max(leftHeight, rightHeight) + 1;
            this.replaceInParent(node, adjacent);
            return;
        }
        if (left != null) {
            this.replaceInParent(node, left);
            node.b = null;
        } else if (right != null) {
            this.replaceInParent(node, right);
            node.c = null;
        } else {
            this.replaceInParent(node, null);
        }
        this.rebalance(originalParent, false);
        --this.size;
        ++this.modCount;
    }

    LinkedHashTreeMap$Node<K, V> removeInternalByKey(Object key) {
        LinkedHashTreeMap$Node<K, V> node = this.findByObject(key);
        if (node != null) {
            this.removeInternal(node, true);
        }
        return node;
    }

    private void replaceInParent(LinkedHashTreeMap$Node<K, V> node, LinkedHashTreeMap$Node<K, V> replacement) {
        LinkedHashTreeMap$Node parent = node.a;
        node.a = null;
        if (replacement != null) {
            replacement.a = parent;
        }
        if (parent != null) {
            if (parent.b == node) {
                parent.b = replacement;
            } else {
                assert (parent.c == node);
                parent.c = replacement;
            }
        } else {
            int index = node.a & this.table.length - 1;
            this.table[index] = replacement;
        }
    }

    private void rebalance(LinkedHashTreeMap$Node<K, V> unbalanced, boolean insert) {
        LinkedHashTreeMap$Node<K, V> node = unbalanced;
        while (node != null) {
            LinkedHashTreeMap$Node right;
            int rightHeight;
            LinkedHashTreeMap$Node left = node.b;
            int leftHeight = left != null ? left.b : 0;
            int delta = leftHeight - (rightHeight = (right = node.c) != null ? right.b : 0);
            if (delta == -2) {
                LinkedHashTreeMap$Node rightRight;
                int rightRightHeight;
                LinkedHashTreeMap$Node rightLeft = right.b;
                int rightLeftHeight = rightLeft != null ? rightLeft.b : 0;
                int rightDelta = rightLeftHeight - (rightRightHeight = (rightRight = right.c) != null ? rightRight.b : 0);
                if (rightDelta == -1 || rightDelta == 0 && !insert) {
                    this.rotateLeft(node);
                } else {
                    assert (rightDelta == 1);
                    this.rotateRight(right);
                    this.rotateLeft(node);
                }
                if (insert) {
                    break;
                }
            } else if (delta == 2) {
                LinkedHashTreeMap$Node leftRight;
                int leftRightHeight;
                LinkedHashTreeMap$Node leftLeft = left.b;
                int leftLeftHeight = leftLeft != null ? leftLeft.b : 0;
                int leftDelta = leftLeftHeight - (leftRightHeight = (leftRight = left.c) != null ? leftRight.b : 0);
                if (leftDelta == 1 || leftDelta == 0 && !insert) {
                    this.rotateRight(node);
                } else {
                    assert (leftDelta == -1);
                    this.rotateLeft(left);
                    this.rotateRight(node);
                }
                if (insert) {
                    break;
                }
            } else if (delta == 0) {
                node.b = leftHeight + 1;
                if (insert) {
                    break;
                }
            } else {
                assert (delta == -1 || delta == 1);
                node.b = Math.max(leftHeight, rightHeight) + 1;
                if (!insert) break;
            }
            node = node.a;
        }
    }

    private void rotateLeft(LinkedHashTreeMap$Node<K, V> root) {
        LinkedHashTreeMap$Node left = root.b;
        LinkedHashTreeMap$Node pivot = root.c;
        LinkedHashTreeMap$Node pivotLeft = pivot.b;
        LinkedHashTreeMap$Node pivotRight = pivot.c;
        root.c = pivotLeft;
        if (pivotLeft != null) {
            pivotLeft.a = root;
        }
        this.replaceInParent(root, pivot);
        pivot.b = root;
        root.a = pivot;
        root.b = Math.max(left != null ? left.b : 0, pivotLeft != null ? pivotLeft.b : 0) + 1;
        pivot.b = Math.max(root.b, pivotRight != null ? pivotRight.b : 0) + 1;
    }

    private void rotateRight(LinkedHashTreeMap$Node<K, V> root) {
        LinkedHashTreeMap$Node pivot = root.b;
        LinkedHashTreeMap$Node right = root.c;
        LinkedHashTreeMap$Node pivotLeft = pivot.b;
        LinkedHashTreeMap$Node pivotRight = pivot.c;
        root.b = pivotRight;
        if (pivotRight != null) {
            pivotRight.a = root;
        }
        this.replaceInParent(root, pivot);
        pivot.c = root;
        root.a = pivot;
        root.b = Math.max(right != null ? right.b : 0, pivotRight != null ? pivotRight.b : 0) + 1;
        pivot.b = Math.max(root.b, pivotLeft != null ? pivotLeft.b : 0) + 1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashTreeMap$EntrySet result = this.entrySet;
        return result != null ? result : (this.entrySet = new LinkedHashTreeMap$EntrySet(this));
    }

    @Override
    public Set<K> keySet() {
        LinkedHashTreeMap$KeySet result = this.keySet;
        return result != null ? result : (this.keySet = new LinkedHashTreeMap$KeySet(this));
    }

    private void doubleCapacity() {
        this.table = LinkedHashTreeMap.doubleCapacity(this.table);
        this.threshold = this.table.length / 2 + this.table.length / 4;
    }

    static <K, V> LinkedHashTreeMap$Node<K, V>[] doubleCapacity(LinkedHashTreeMap$Node<K, V>[] oldTable) {
        int oldCapacity = oldTable.length;
        LinkedHashTreeMap$Node[] newTable = new LinkedHashTreeMap$Node[oldCapacity * 2];
        LinkedHashTreeMap$AvlIterator<K, V> iterator = new LinkedHashTreeMap$AvlIterator<K, V>();
        LinkedHashTreeMap$AvlBuilder leftBuilder = new LinkedHashTreeMap$AvlBuilder();
        LinkedHashTreeMap$AvlBuilder rightBuilder = new LinkedHashTreeMap$AvlBuilder();
        for (int i2 = 0; i2 < oldCapacity; ++i2) {
            LinkedHashTreeMap$Node node;
            LinkedHashTreeMap$Node<K, V> root = oldTable[i2];
            if (root == null) continue;
            iterator.a(root);
            int leftSize = 0;
            int rightSize = 0;
            while ((node = iterator.a()) != null) {
                if ((node.a & oldCapacity) == 0) {
                    ++leftSize;
                    continue;
                }
                ++rightSize;
            }
            leftBuilder.a(leftSize);
            rightBuilder.a(rightSize);
            iterator.a(root);
            while ((node = iterator.a()) != null) {
                if ((node.a & oldCapacity) == 0) {
                    leftBuilder.a(node);
                    continue;
                }
                rightBuilder.a(node);
            }
            newTable[i2] = leftSize > 0 ? leftBuilder.a() : null;
            newTable[i2 + oldCapacity] = rightSize > 0 ? rightBuilder.a() : null;
        }
        return newTable;
    }

    private Object writeReplace() {
        return new LinkedHashMap(this);
    }
}

