/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.JavaVersion;
import com.google.gson.internal.PreJava9DateFormatProvider;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
final class DefaultDateTypeAdapter
extends TypeAdapter<java.util.Date> {
    private final Class<? extends java.util.Date> a;
    private final List<DateFormat> a = new ArrayList();

    DefaultDateTypeAdapter(Class<? extends java.util.Date> dateType, String datePattern) {
        this.a = DefaultDateTypeAdapter.a(dateType);
        this.a.add((SimpleDateFormat)new SimpleDateFormat(datePattern, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.a.add((SimpleDateFormat)new SimpleDateFormat(datePattern));
        }
    }

    public DefaultDateTypeAdapter(Class<? extends java.util.Date> dateType, int dateStyle, int timeStyle) {
        this.a = DefaultDateTypeAdapter.a(dateType);
        this.a.add((DateFormat)DateFormat.getDateTimeInstance(dateStyle, timeStyle, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.a.add((DateFormat)DateFormat.getDateTimeInstance(dateStyle, timeStyle));
        }
        if (JavaVersion.a()) {
            this.a.add((DateFormat)PreJava9DateFormatProvider.a(dateStyle, timeStyle));
        }
    }

    private static Class<? extends java.util.Date> a(Class<? extends java.util.Date> dateType) {
        if (dateType != java.util.Date.class && dateType != Date.class && dateType != Timestamp.class) {
            throw new IllegalArgumentException("Date type must be one of " + java.util.Date.class + ", " + Timestamp.class + ", or " + Date.class + " but was " + dateType);
        }
        return dateType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(JsonWriter out, java.util.Date value) {
        if (value == null) {
            out.e();
            return;
        }
        Class<? extends java.util.Date> clazz = this.a;
        synchronized (clazz) {
            String dateFormatAsString = ((DateFormat)this.a.get(0)).format(value);
            out.b(dateFormatAsString);
        }
    }

    @Override
    public java.util.Date a(JsonReader in2) {
        if (in2.a() == JsonToken.NULL) {
            in2.e();
            return null;
        }
        java.util.Date date = this.a(in2.b());
        if (this.a == java.util.Date.class) {
            return date;
        }
        if (this.a == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (this.a == Date.class) {
            return new Date(date.getTime());
        }
        throw new AssertionError();
    }

    @Override
    private java.util.Date a(String s2) {
        Class<? extends java.util.Date> clazz = this.a;
        synchronized (clazz) {
            Iterator iterator = this.a.iterator();
            while (iterator.hasNext()) {
                DateFormat dateFormat = (DateFormat)iterator.next();
                try {
                    return dateFormat.parse(s2);
                }
                catch (ParseException parseException) {
                }
            }
            try {
                return ISO8601Utils.a(s2, new ParsePosition(0));
            }
            catch (ParseException e2) {
                throw new JsonSyntaxException(s2, e2);
            }
        }
    }

    public String toString() {
        DateFormat defaultFormat = (DateFormat)this.a.get(0);
        if (defaultFormat instanceof SimpleDateFormat) {
            return "DefaultDateTypeAdapter(" + ((SimpleDateFormat)defaultFormat).toPattern() + ')';
        }
        return "DefaultDateTypeAdapter(" + defaultFormat.getClass().getSimpleName() + ')';
    }
}

