/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonAutoDetect$Visibility;
import com.fasterxml.jackson.annotation.JsonInclude$Include;
import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.annotation.JsonTypeInfo$Id;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactory$Feature;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper$DefaultTyping;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectMapper
extends el
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final fC JSON_NODE_TYPE = nM.constructUnsafe(fH.class);
    protected static final jL DEFAULT_INTROSPECTOR = jJ.instance;
    protected static final AnnotationIntrospector DEFAULT_ANNOTATION_INTROSPECTOR = new jN();
    protected static final kc<?> STD_VISIBILITY_CHECKER = ke.defaultInstance();
    protected static final em _defaultPrettyPrinter = new fi();
    protected static final gh DEFAULT_BASE = new gh(DEFAULT_INTROSPECTOR, DEFAULT_ANNOTATION_INTROSPECTOR, STD_VISIBILITY_CHECKER, null, nP.defaultInstance(), null, oC.instance, null, Locale.getDefault(), TimeZone.getTimeZone("GMT"), ee.a());
    public final JsonFactory _jsonFactory;
    protected nP _typeFactory;
    protected fB _injectableValues;
    protected kv _subtypeResolver;
    public final oA _rootNames;
    protected final HashMap<nG, Class<?>> _mixInAnnotations;
    protected gd _serializationConfig;
    public lB _serializerProvider;
    public lL _serializerFactory;
    protected fz _deserializationConfig;
    public gI _deserializationContext;
    public final ConcurrentHashMap<fC, fD<Object>> _rootDeserializers = new ConcurrentHashMap(64, 0.6f, 2);

    public ObjectMapper() {
        this(null, null, null);
    }

    public ObjectMapper(JsonFactory jsonFactory) {
        this(jsonFactory, null, null);
    }

    protected ObjectMapper(ObjectMapper objectMapper) {
        this._jsonFactory = objectMapper._jsonFactory.copy();
        this._jsonFactory.setCodec(this);
        this._subtypeResolver = objectMapper._subtypeResolver;
        this._rootNames = new oA();
        this._typeFactory = objectMapper._typeFactory;
        this._serializationConfig = objectMapper._serializationConfig;
        HashMap hashMap = new HashMap(objectMapper._mixInAnnotations);
        this._mixInAnnotations = hashMap;
        this._serializationConfig = new gd(objectMapper._serializationConfig, (Map<nG, Class<?>>)hashMap);
        this._deserializationConfig = new fz(objectMapper._deserializationConfig, (Map<nG, Class<?>>)hashMap);
        this._serializerProvider = objectMapper._serializerProvider;
        this._deserializationContext = objectMapper._deserializationContext;
        this._serializerFactory = objectMapper._serializerFactory;
    }

    public ObjectMapper(JsonFactory jsonFactory, lB lB2, gI gI2) {
        if (jsonFactory == null) {
            this._jsonFactory = new fO(this);
        } else {
            this._jsonFactory = jsonFactory;
            if (jsonFactory.getCodec() == null) {
                this._jsonFactory.setCodec(this);
            }
        }
        this._subtypeResolver = new kL();
        this._rootNames = new oA();
        this._typeFactory = nP.defaultInstance();
        HashMap hashMap = new HashMap();
        this._mixInAnnotations = hashMap;
        this._serializationConfig = new gd(DEFAULT_BASE, this._subtypeResolver, hashMap);
        this._deserializationConfig = new fz(DEFAULT_BASE, this._subtypeResolver, hashMap);
        boolean bl2 = this._jsonFactory.requiresPropertyOrdering();
        if (bl2 ^ this._serializationConfig.isEnabled(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY)) {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, bl2);
        }
        this._serializerProvider = lB2 == null ? new lC() : lB2;
        this._deserializationContext = gI2 == null ? new gJ(gy.instance) : gI2;
        this._serializerFactory = lx.instance;
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(ObjectMapper.class);
        return new ObjectMapper(this);
    }

    protected void _checkInvalidCopy(Class<?> clazz) {
        if (this.getClass() != clazz) {
            throw new IllegalStateException("Failed copy(): " + this.getClass().getName() + " (version: " + this.version() + ") does not override copy(); it has to");
        }
    }

    @Override
    public eq version() {
        return gp.a;
    }

    public ObjectMapper registerModule(fP fP2) {
        String string = fP2.a();
        if (string == null) {
            throw new IllegalArgumentException("Module without defined name");
        }
        eq eq2 = fP2.a();
        if (eq2 == null) {
            throw new IllegalArgumentException("Module without defined version");
        }
        ObjectMapper objectMapper = this;
        fP2.a(new fR(this, objectMapper));
        return this;
    }

    public ObjectMapper registerModules(fP ... fPArray) {
        for (fP fP2 : fPArray) {
            this.registerModule(fP2);
        }
        return this;
    }

    public ObjectMapper registerModules(Iterable<fP> iterable) {
        for (fP fP2 : iterable) {
            this.registerModule(fP2);
        }
        return this;
    }

    public static List<fP> findModules() {
        return ObjectMapper.findModules(null);
    }

    public static List<fP> findModules(ClassLoader classLoader) {
        ArrayList<fP> arrayList = new ArrayList<fP>();
        ServiceLoader<fP> serviceLoader = classLoader == null ? ServiceLoader.load(fP.class) : ServiceLoader.load(fP.class, classLoader);
        for (fP fP2 : serviceLoader) {
            arrayList.add(fP2);
        }
        return arrayList;
    }

    public ObjectMapper findAndRegisterModules() {
        return this.registerModules(ObjectMapper.findModules());
    }

    public gd getSerializationConfig() {
        return this._serializationConfig;
    }

    public fz getDeserializationConfig() {
        return this._deserializationConfig;
    }

    public fA getDeserializationContext() {
        return this._deserializationContext;
    }

    public ObjectMapper setSerializerFactory(lL lL2) {
        this._serializerFactory = lL2;
        return this;
    }

    public lL getSerializerFactory() {
        return this._serializerFactory;
    }

    public ObjectMapper setSerializerProvider(lB lB2) {
        this._serializerProvider = lB2;
        return this;
    }

    public ge getSerializerProvider() {
        return this._serializerProvider;
    }

    public final void setMixInAnnotations(Map<Class<?>, Class<?>> map) {
        this._mixInAnnotations.clear();
        if (map != null && map.size() > 0) {
            for (Map.Entry<Class<?>, Class<?>> entry : map.entrySet()) {
                this._mixInAnnotations.put(new nG(entry.getKey()), entry.getValue());
            }
        }
    }

    public final void addMixInAnnotations(Class<?> clazz, Class<?> clazz2) {
        this._mixInAnnotations.put(new nG(clazz), clazz2);
    }

    public final Class<?> findMixInClassFor(Class<?> clazz) {
        return this._mixInAnnotations == null ? null : this._mixInAnnotations.get(new nG(clazz));
    }

    public final int mixInCount() {
        return this._mixInAnnotations == null ? 0 : this._mixInAnnotations.size();
    }

    public kc<?> getVisibilityChecker() {
        return this._serializationConfig.getDefaultVisibilityChecker();
    }

    public void setVisibilityChecker(kc<?> kc2) {
        this._deserializationConfig = this._deserializationConfig.with((kc)kc2);
        this._serializationConfig = this._serializationConfig.with((kc)kc2);
    }

    public ObjectMapper setVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect$Visibility jsonAutoDetect$Visibility) {
        this._deserializationConfig = this._deserializationConfig.withVisibility(propertyAccessor, jsonAutoDetect$Visibility);
        this._serializationConfig = this._serializationConfig.withVisibility(propertyAccessor, jsonAutoDetect$Visibility);
        return this;
    }

    public kv getSubtypeResolver() {
        return this._subtypeResolver;
    }

    public ObjectMapper setSubtypeResolver(kv kv2) {
        this._subtypeResolver = kv2;
        this._deserializationConfig = this._deserializationConfig.with(kv2);
        this._serializationConfig = this._serializationConfig.with(kv2);
        return this;
    }

    public ObjectMapper setAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        this._serializationConfig = this._serializationConfig.with(annotationIntrospector);
        this._deserializationConfig = this._deserializationConfig.with(annotationIntrospector);
        return this;
    }

    public ObjectMapper setAnnotationIntrospectors(AnnotationIntrospector annotationIntrospector, AnnotationIntrospector annotationIntrospector2) {
        this._serializationConfig = this._serializationConfig.with(annotationIntrospector);
        this._deserializationConfig = this._deserializationConfig.with(annotationIntrospector2);
        return this;
    }

    public ObjectMapper setPropertyNamingStrategy(fY fY2) {
        this._serializationConfig = this._serializationConfig.with(fY2);
        this._deserializationConfig = this._deserializationConfig.with(fY2);
        return this;
    }

    public ObjectMapper setSerializationInclusion(JsonInclude$Include jsonInclude$Include) {
        this._serializationConfig = this._serializationConfig.withSerializationInclusion(jsonInclude$Include);
        return this;
    }

    public ObjectMapper enableDefaultTyping() {
        return this.enableDefaultTyping(ObjectMapper$DefaultTyping.OBJECT_AND_NON_CONCRETE);
    }

    public ObjectMapper enableDefaultTyping(ObjectMapper$DefaultTyping objectMapper$DefaultTyping) {
        return this.enableDefaultTyping(objectMapper$DefaultTyping, JsonTypeInfo$As.WRAPPER_ARRAY);
    }

    public ObjectMapper enableDefaultTyping(ObjectMapper$DefaultTyping objectMapper$DefaultTyping, JsonTypeInfo$As jsonTypeInfo$As) {
        fT fT2 = new fT(objectMapper$DefaultTyping);
        fT2 = fT2.init(JsonTypeInfo$Id.CLASS, null);
        fT2 = fT2.inclusion(jsonTypeInfo$As);
        return this.setDefaultTyping(fT2);
    }

    public ObjectMapper enableDefaultTypingAsProperty(ObjectMapper$DefaultTyping objectMapper$DefaultTyping, String string) {
        fT fT2 = new fT(objectMapper$DefaultTyping);
        fT2 = fT2.init(JsonTypeInfo$Id.CLASS, null);
        fT2 = fT2.inclusion(JsonTypeInfo$As.PROPERTY);
        fT2 = fT2.typeProperty(string);
        return this.setDefaultTyping(fT2);
    }

    public ObjectMapper disableDefaultTyping() {
        return this.setDefaultTyping(null);
    }

    public ObjectMapper setDefaultTyping(kz<?> kz2) {
        this._deserializationConfig = this._deserializationConfig.with((kz)kz2);
        this._serializationConfig = this._serializationConfig.with((kz)kz2);
        return this;
    }

    public void registerSubtypes(Class<?> ... classArray) {
        this.getSubtypeResolver().registerSubtypes(classArray);
    }

    public void registerSubtypes(ku ... kuArray) {
        this.getSubtypeResolver().registerSubtypes(kuArray);
    }

    public nP getTypeFactory() {
        return this._typeFactory;
    }

    public ObjectMapper setTypeFactory(nP nP2) {
        this._typeFactory = nP2;
        this._deserializationConfig = this._deserializationConfig.with(nP2);
        this._serializationConfig = this._serializationConfig.with(nP2);
        return this;
    }

    public fC constructType(Type type) {
        return this._typeFactory.constructType(type);
    }

    public ObjectMapper setNodeFactory(lc lc2) {
        this._deserializationConfig = this._deserializationConfig.with(lc2);
        return this;
    }

    public ObjectMapper addHandler(gK gK2) {
        this._deserializationConfig = this._deserializationConfig.withHandler(gK2);
        return this;
    }

    public ObjectMapper clearProblemHandlers() {
        this._deserializationConfig = this._deserializationConfig.withNoProblemHandlers();
        return this;
    }

    public void setFilters(lD lD2) {
        this._serializationConfig = this._serializationConfig.withFilters(lD2);
    }

    public ObjectMapper setBase64Variant(ed ed2) {
        this._serializationConfig = this._serializationConfig.with(ed2);
        this._deserializationConfig = this._deserializationConfig.with(ed2);
        return this;
    }

    @Override
    public JsonFactory getFactory() {
        return this._jsonFactory;
    }

    @Override
    @Deprecated
    public JsonFactory getJsonFactory() {
        return this._jsonFactory;
    }

    public ObjectMapper setDateFormat(DateFormat dateFormat) {
        this._deserializationConfig = this._deserializationConfig.with(dateFormat);
        this._serializationConfig = this._serializationConfig.with(dateFormat);
        return this;
    }

    public Object setHandlerInstantiator(gm gm2) {
        this._deserializationConfig = this._deserializationConfig.with(gm2);
        this._serializationConfig = this._serializationConfig.with(gm2);
        return this;
    }

    public ObjectMapper setInjectableValues(fB fB2) {
        this._injectableValues = fB2;
        return this;
    }

    public ObjectMapper setLocale(Locale locale) {
        this._deserializationConfig = this._deserializationConfig.with(locale);
        this._serializationConfig = this._serializationConfig.with(locale);
        return this;
    }

    public ObjectMapper setTimeZone(TimeZone timeZone) {
        this._deserializationConfig = this._deserializationConfig.with(timeZone);
        this._serializationConfig = this._serializationConfig.with(timeZone);
        return this;
    }

    public ObjectMapper configure(MapperFeature mapperFeature, boolean bl2) {
        this._serializationConfig = bl2 ? this._serializationConfig.with(mapperFeature) : this._serializationConfig.without(mapperFeature);
        this._deserializationConfig = bl2 ? this._deserializationConfig.with(mapperFeature) : this._deserializationConfig.without(mapperFeature);
        return this;
    }

    public ObjectMapper configure(SerializationFeature serializationFeature, boolean bl2) {
        this._serializationConfig = bl2 ? this._serializationConfig.with(serializationFeature) : this._serializationConfig.without(serializationFeature);
        return this;
    }

    public ObjectMapper configure(DeserializationFeature deserializationFeature, boolean bl2) {
        this._deserializationConfig = bl2 ? this._deserializationConfig.with(deserializationFeature) : this._deserializationConfig.without(deserializationFeature);
        return this;
    }

    public ObjectMapper configure(JsonParser$Feature jsonParser$Feature, boolean bl2) {
        this._jsonFactory.configure(jsonParser$Feature, bl2);
        return this;
    }

    public ObjectMapper configure(JsonGenerator$Feature jsonGenerator$Feature, boolean bl2) {
        this._jsonFactory.configure(jsonGenerator$Feature, bl2);
        return this;
    }

    public ObjectMapper enable(MapperFeature ... mapperFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.with(mapperFeatureArray);
        this._serializationConfig = this._serializationConfig.with(mapperFeatureArray);
        return this;
    }

    public ObjectMapper disable(MapperFeature ... mapperFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.without(mapperFeatureArray);
        this._serializationConfig = this._serializationConfig.without(mapperFeatureArray);
        return this;
    }

    public ObjectMapper enable(DeserializationFeature deserializationFeature) {
        this._deserializationConfig = this._deserializationConfig.with(deserializationFeature);
        return this;
    }

    public ObjectMapper enable(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.with(deserializationFeature, deserializationFeatureArray);
        return this;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature) {
        this._deserializationConfig = this._deserializationConfig.without(deserializationFeature);
        return this;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.without(deserializationFeature, deserializationFeatureArray);
        return this;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature) {
        this._serializationConfig = this._serializationConfig.with(serializationFeature);
        return this;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        this._serializationConfig = this._serializationConfig.with(serializationFeature, serializationFeatureArray);
        return this;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature) {
        this._serializationConfig = this._serializationConfig.without(serializationFeature);
        return this;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        this._serializationConfig = this._serializationConfig.without(serializationFeature, serializationFeatureArray);
        return this;
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._serializationConfig.isEnabled(mapperFeature);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._serializationConfig.isEnabled(serializationFeature);
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return this._deserializationConfig.isEnabled(deserializationFeature);
    }

    public boolean isEnabled(JsonFactory$Feature jsonFactory$Feature) {
        return this._jsonFactory.isEnabled(jsonFactory$Feature);
    }

    public boolean isEnabled(JsonParser$Feature jsonParser$Feature) {
        return this._jsonFactory.isEnabled(jsonParser$Feature);
    }

    public boolean isEnabled(JsonGenerator$Feature jsonGenerator$Feature) {
        return this._jsonFactory.isEnabled(jsonGenerator$Feature);
    }

    public lc getNodeFactory() {
        return this._deserializationConfig.getNodeFactory();
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(clazz));
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, ff<?> ff2) {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(ff2));
    }

    @Override
    public final <T> T readValue(JsonParser jsonParser, fe fe2) {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, (fC)fe2);
    }

    public <T> T readValue(JsonParser jsonParser, fC fC2) {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, fC2);
    }

    @Override
    public <T extends ep> T readTree(JsonParser jsonParser) {
        fz fz2 = this.getDeserializationConfig();
        JsonToken jsonToken = jsonParser.c();
        if (jsonToken == null && (jsonToken = jsonParser.a()) == null) {
            return null;
        }
        fH fH2 = (fH)this._readValue(fz2, jsonParser, JSON_NODE_TYPE);
        if (fH2 == null) {
            fH2 = this.getNodeFactory().nullNode();
        }
        fH fH3 = fH2;
        return (T)fH3;
    }

    public <T> fN<T> readValues(JsonParser jsonParser, fe fe2) {
        return this.readValues(jsonParser, (fC)fe2);
    }

    public <T> fN<T> readValues(JsonParser jsonParser, fC fC2) {
        fz fz2 = this.getDeserializationConfig();
        gI gI2 = this.createDeserializationContext(jsonParser, fz2);
        fD<Object> fD2 = this._findRootDeserializer(gI2, fC2);
        return new fN(fC2, jsonParser, gI2, fD2, false, null);
    }

    public <T> fN<T> readValues(JsonParser jsonParser, Class<T> clazz) {
        return this.readValues(jsonParser, this._typeFactory.constructType(clazz));
    }

    public <T> fN<T> readValues(JsonParser jsonParser, ff<?> ff2) {
        return this.readValues(jsonParser, this._typeFactory.constructType(ff2));
    }

    public fH readTree(InputStream inputStream) {
        fH fH2 = (fH)this._readMapAndClose(this._jsonFactory.createParser(inputStream), JSON_NODE_TYPE);
        return fH2 == null ? li.a : fH2;
    }

    public fH readTree(Reader reader) {
        fH fH2 = (fH)this._readMapAndClose(this._jsonFactory.createParser(reader), JSON_NODE_TYPE);
        return fH2 == null ? li.a : fH2;
    }

    public fH readTree(String string) {
        fH fH2 = (fH)this._readMapAndClose(this._jsonFactory.createParser(string), JSON_NODE_TYPE);
        return fH2 == null ? li.a : fH2;
    }

    public fH readTree(byte[] byArray) {
        fH fH2 = (fH)this._readMapAndClose(this._jsonFactory.createParser(byArray), JSON_NODE_TYPE);
        return fH2 == null ? li.a : fH2;
    }

    public fH readTree(File file) {
        fH fH2 = (fH)this._readMapAndClose(this._jsonFactory.createParser(file), JSON_NODE_TYPE);
        return fH2 == null ? li.a : fH2;
    }

    public fH readTree(URL uRL) {
        fH fH2 = (fH)this._readMapAndClose(this._jsonFactory.createParser(uRL), JSON_NODE_TYPE);
        return fH2 == null ? li.a : fH2;
    }

    @Override
    public void writeValue(JsonGenerator jsonGenerator, Object object) {
        gd gd2 = this.getSerializationConfig();
        if (gd2.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jsonGenerator.a();
        }
        if (gd2.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseableValue(jsonGenerator, object, gd2);
        } else {
            this._serializerProvider(gd2).serializeValue(jsonGenerator, object);
            if (gd2.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
    }

    @Override
    public void writeTree(JsonGenerator jsonGenerator, ep ep2) {
        gd gd2 = this.getSerializationConfig();
        this._serializerProvider(gd2).serializeValue(jsonGenerator, ep2);
        if (gd2.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    public void writeTree(JsonGenerator jsonGenerator, fH fH2) {
        gd gd2 = this.getSerializationConfig();
        this._serializerProvider(gd2).serializeValue(jsonGenerator, fH2);
        if (gd2.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    @Override
    public lk createObjectNode() {
        return this._deserializationConfig.getNodeFactory().objectNode();
    }

    @Override
    public kS createArrayNode() {
        return this._deserializationConfig.getNodeFactory().arrayNode();
    }

    @Override
    public JsonParser treeAsTokens(ep ep2) {
        return new lo((fH)ep2, this);
    }

    @Override
    public <T> T treeToValue(ep ep2, Class<T> clazz) {
        try {
            if (clazz != Object.class && clazz.isAssignableFrom(ep2.getClass())) {
                return (T)ep2;
            }
            return this.readValue(this.treeAsTokens(ep2), clazz);
        }
        catch (ej ej2) {
            throw ej2;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    public <T extends fH> T valueToTree(Object object) {
        fH fH2;
        if (object == null) {
            return null;
        }
        oD oD2 = new oD(this, false);
        try {
            this.writeValue(oD2, object);
            JsonParser jsonParser = oD2.a();
            fH2 = (fH)this.readTree(jsonParser);
            jsonParser.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
        return (T)fH2;
    }

    public boolean canSerialize(Class<?> clazz) {
        return this._serializerProvider(this.getSerializationConfig()).hasSerializerFor(clazz, null);
    }

    public boolean canSerialize(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        return this._serializerProvider(this.getSerializationConfig()).hasSerializerFor(clazz, atomicReference);
    }

    public boolean canDeserialize(fC fC2) {
        return this.createDeserializationContext(null, this.getDeserializationConfig()).hasValueDeserializerFor(fC2, null);
    }

    public boolean canDeserialize(fC fC2, AtomicReference<Throwable> atomicReference) {
        return this.createDeserializationContext(null, this.getDeserializationConfig()).hasValueDeserializerFor(fC2, atomicReference);
    }

    public <T> T readValue(File file, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(file), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(File file, ff ff2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(file), this._typeFactory.constructType(ff2));
    }

    public <T> T readValue(File file, fC fC2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(file), fC2);
    }

    public <T> T readValue(URL uRL, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(uRL), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(URL uRL, ff ff2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(uRL), this._typeFactory.constructType(ff2));
    }

    public <T> T readValue(URL uRL, fC fC2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(uRL), fC2);
    }

    public <T> T readValue(String string, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(string), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(String string, ff ff2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(string), this._typeFactory.constructType(ff2));
    }

    public <T> T readValue(String string, fC fC2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(string), fC2);
    }

    public <T> T readValue(Reader reader, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(reader), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(Reader reader, ff ff2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(reader), this._typeFactory.constructType(ff2));
    }

    public <T> T readValue(Reader reader, fC fC2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(reader), fC2);
    }

    public <T> T readValue(InputStream inputStream, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(inputStream), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(InputStream inputStream, ff ff2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(inputStream), this._typeFactory.constructType(ff2));
    }

    public <T> T readValue(InputStream inputStream, fC fC2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(inputStream), fC2);
    }

    public <T> T readValue(byte[] byArray, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray, n2, n3), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, ff ff2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray), this._typeFactory.constructType(ff2));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, ff ff2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray, n2, n3), this._typeFactory.constructType(ff2));
    }

    public <T> T readValue(byte[] byArray, fC fC2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray), fC2);
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, fC fC2) {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray, n2, n3), fC2);
    }

    public void writeValue(File file, Object object) {
        this._configAndWriteValue(this._jsonFactory.createGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) {
        this._configAndWriteValue(this._jsonFactory.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(Writer writer, Object object) {
        this._configAndWriteValue(this._jsonFactory.createGenerator(writer), object);
    }

    public String writeValueAsString(Object object) {
        eG eG2 = new eG(this._jsonFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._jsonFactory.createGenerator(eG2), object);
        }
        catch (ej ej2) {
            throw ej2;
        }
        catch (IOException iOException) {
            throw fF.fromUnexpectedIOE(iOException);
        }
        return eG2.a();
    }

    public byte[] writeValueAsBytes(Object object) {
        fh fh2 = new fh(this._jsonFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._jsonFactory.createGenerator(fh2, JsonEncoding.UTF8), object);
        }
        catch (ej ej2) {
            throw ej2;
        }
        catch (IOException iOException) {
            throw fF.fromUnexpectedIOE(iOException);
        }
        byte[] byArray = fh2.a();
        fh2.b();
        return byArray;
    }

    public fV writer() {
        return new fV(this, this.getSerializationConfig());
    }

    public fV writer(SerializationFeature serializationFeature) {
        return new fV(this, this.getSerializationConfig().with(serializationFeature));
    }

    public fV writer(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        return new fV(this, this.getSerializationConfig().with(serializationFeature, serializationFeatureArray));
    }

    public fV writer(DateFormat dateFormat) {
        return new fV(this, this.getSerializationConfig().with(dateFormat));
    }

    public fV writerWithView(Class<?> clazz) {
        return new fV(this, (gd)this.getSerializationConfig().withView((Class)clazz));
    }

    public fV writerWithType(Class<?> clazz) {
        return new fV(this, this.getSerializationConfig(), clazz == null ? null : this._typeFactory.constructType(clazz), null);
    }

    public fV writerWithType(ff<?> ff2) {
        return new fV(this, this.getSerializationConfig(), ff2 == null ? null : this._typeFactory.constructType(ff2), null);
    }

    public fV writerWithType(fC fC2) {
        return new fV(this, this.getSerializationConfig(), fC2, null);
    }

    public fV writer(em em2) {
        if (em2 == null) {
            em2 = fV.NULL_PRETTY_PRINTER;
        }
        return new fV(this, this.getSerializationConfig(), null, em2);
    }

    public fV writerWithDefaultPrettyPrinter() {
        return new fV(this, this.getSerializationConfig(), null, this._defaultPrettyPrinter());
    }

    public fV writer(lD lD2) {
        return new fV(this, this.getSerializationConfig().withFilters(lD2));
    }

    public fV writer(ef ef2) {
        this._verifySchemaType(ef2);
        return new fV(this, this.getSerializationConfig(), ef2);
    }

    public fV writer(ed ed2) {
        return new fV(this, this.getSerializationConfig().with(ed2));
    }

    public fV writer(ey ey2) {
        return this.writer().with(ey2);
    }

    public fV writer(gj gj2) {
        return new fV(this, this.getSerializationConfig().with(gj2));
    }

    public fU reader() {
        return new fU(this, this.getDeserializationConfig()).with(this._injectableValues);
    }

    public fU reader(DeserializationFeature deserializationFeature) {
        return new fU(this, this.getDeserializationConfig().with(deserializationFeature));
    }

    public fU reader(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        return new fU(this, this.getDeserializationConfig().with(deserializationFeature, deserializationFeatureArray));
    }

    public fU readerForUpdating(Object object) {
        fC fC2 = this._typeFactory.constructType(object.getClass());
        return new fU(this, this.getDeserializationConfig(), fC2, object, null, this._injectableValues);
    }

    public fU reader(fC fC2) {
        return new fU(this, this.getDeserializationConfig(), fC2, null, null, this._injectableValues);
    }

    public fU reader(Class<?> clazz) {
        return this.reader(this._typeFactory.constructType(clazz));
    }

    public fU reader(ff<?> ff2) {
        return this.reader(this._typeFactory.constructType(ff2));
    }

    public fU reader(lc lc2) {
        return new fU(this, this.getDeserializationConfig()).with(lc2);
    }

    public fU reader(ef ef2) {
        this._verifySchemaType(ef2);
        return new fU(this, this.getDeserializationConfig(), null, null, ef2, this._injectableValues);
    }

    public fU reader(fB fB2) {
        return new fU(this, this.getDeserializationConfig(), null, null, null, fB2);
    }

    public fU readerWithView(Class<?> clazz) {
        return new fU(this, (fz)this.getDeserializationConfig().withView((Class)clazz));
    }

    public fU reader(ed ed2) {
        return new fU(this, this.getDeserializationConfig().with(ed2));
    }

    public fU reader(gj gj2) {
        return new fU(this, this.getDeserializationConfig().with(gj2));
    }

    public <T> T convertValue(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        return (T)this._convert(object, this._typeFactory.constructType(clazz));
    }

    public <T> T convertValue(Object object, ff<?> ff2) {
        return this.convertValue(object, this._typeFactory.constructType(ff2));
    }

    public <T> T convertValue(Object object, fC fC2) {
        if (object == null) {
            return null;
        }
        return (T)this._convert(object, fC2);
    }

    protected Object _convert(Object object, fC fC2) {
        Class<?> clazz = fC2.getRawClass();
        if (clazz != Object.class && !fC2.hasGenericTypes() && clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        oD oD2 = new oD(this, false);
        try {
            Object object2;
            gd gd2 = this.getSerializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
            this._serializerProvider(gd2).serializeValue(oD2, object);
            JsonParser jsonParser = oD2.a();
            fz fz2 = this.getDeserializationConfig();
            JsonToken jsonToken = this._initForReading(jsonParser);
            if (jsonToken == JsonToken.VALUE_NULL) {
                gI gI2 = this.createDeserializationContext(jsonParser, fz2);
                object2 = this._findRootDeserializer(gI2, fC2).getNullValue();
            } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                object2 = null;
            } else {
                gI gI3 = this.createDeserializationContext(jsonParser, fz2);
                fD<Object> fD2 = this._findRootDeserializer(gI3, fC2);
                object2 = fD2.deserialize(jsonParser, gI3);
            }
            jsonParser.close();
            return object2;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    public ks generateJsonSchema(Class<?> clazz) {
        return this._serializerProvider(this.getSerializationConfig()).generateJsonSchema(clazz);
    }

    public void acceptJsonFormatVisitor(Class<?> clazz, kk kk2) {
        this.acceptJsonFormatVisitor(this._typeFactory.constructType(clazz), kk2);
    }

    public void acceptJsonFormatVisitor(fC fC2, kk kk2) {
        if (fC2 == null) {
            throw new IllegalArgumentException("type must be provided");
        }
        this._serializerProvider(this.getSerializationConfig()).acceptJsonFormatVisitor(fC2, kk2);
    }

    protected lB _serializerProvider(gd gd2) {
        return this._serializerProvider.createInstance(gd2, this._serializerFactory);
    }

    protected em _defaultPrettyPrinter() {
        return _defaultPrettyPrinter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object) {
        gd gd2 = this.getSerializationConfig();
        if (gd2.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jsonGenerator.a();
        }
        if (gd2.isEnabled(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN)) {
            jsonGenerator.a(JsonGenerator$Feature.WRITE_BIGDECIMAL_AS_PLAIN);
        }
        if (gd2.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._configAndWriteCloseable(jsonGenerator, object, gd2);
            return;
        }
        boolean bl2 = false;
        try {
            this._serializerProvider(gd2).serializeValue(jsonGenerator, object);
            bl2 = true;
            jsonGenerator.close();
        }
        finally {
            if (!bl2) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object, Class<?> clazz) {
        go go2 = this.getSerializationConfig().withView((Class)clazz);
        if (((gd)go2).isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jsonGenerator.a();
        }
        if (((gd)go2).isEnabled(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN)) {
            jsonGenerator.a(JsonGenerator$Feature.WRITE_BIGDECIMAL_AS_PLAIN);
        }
        if (((gd)go2).isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._configAndWriteCloseable(jsonGenerator, object, (gd)go2);
            return;
        }
        boolean bl2 = false;
        try {
            this._serializerProvider((gd)go2).serializeValue(jsonGenerator, object);
            bl2 = true;
            jsonGenerator.close();
        }
        finally {
            if (!bl2) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _configAndWriteCloseable(JsonGenerator jsonGenerator, Object object, gd gd2) {
        Closeable closeable = (Closeable)object;
        try {
            this._serializerProvider(gd2).serializeValue(jsonGenerator, object);
            JsonGenerator jsonGenerator2 = jsonGenerator;
            jsonGenerator = null;
            jsonGenerator2.close();
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (jsonGenerator != null) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _writeCloseableValue(JsonGenerator jsonGenerator, Object object, gd gd2) {
        Closeable closeable = (Closeable)object;
        try {
            this._serializerProvider(gd2).serializeValue(jsonGenerator, object);
            if (gd2.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected gI createDeserializationContext(JsonParser jsonParser, fz fz2) {
        return this._deserializationContext.createInstance(fz2, jsonParser, this._injectableValues);
    }

    protected Object _readValue(fz fz2, JsonParser jsonParser, fC fC2) {
        Object object;
        JsonToken jsonToken = this._initForReading(jsonParser);
        if (jsonToken == JsonToken.VALUE_NULL) {
            gI gI2 = this.createDeserializationContext(jsonParser, fz2);
            object = this._findRootDeserializer(gI2, fC2).getNullValue();
        } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
            object = null;
        } else {
            gI gI3 = this.createDeserializationContext(jsonParser, fz2);
            fD<Object> fD2 = this._findRootDeserializer(gI3, fC2);
            object = fz2.useRootWrapping() ? this._unwrapAndDeserialize(jsonParser, gI3, fz2, fC2, fD2) : fD2.deserialize(jsonParser, gI3);
        }
        jsonParser.a();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _readMapAndClose(JsonParser jsonParser, fC fC2) {
        try {
            Object object;
            Serializable serializable;
            JsonToken jsonToken = this._initForReading(jsonParser);
            if (jsonToken == JsonToken.VALUE_NULL) {
                serializable = this.createDeserializationContext(jsonParser, this.getDeserializationConfig());
                object = this._findRootDeserializer((fA)serializable, fC2).getNullValue();
            } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                object = null;
            } else {
                serializable = this.getDeserializationConfig();
                gI gI2 = this.createDeserializationContext(jsonParser, (fz)serializable);
                fD<Object> fD2 = this._findRootDeserializer(gI2, fC2);
                object = ((fz)serializable).useRootWrapping() ? this._unwrapAndDeserialize(jsonParser, gI2, (fz)serializable, fC2, fD2) : fD2.deserialize(jsonParser, gI2);
            }
            jsonParser.a();
            serializable = object;
            return serializable;
        }
        finally {
            try {
                jsonParser.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected JsonToken _initForReading(JsonParser jsonParser) {
        JsonToken jsonToken = jsonParser.c();
        if (jsonToken == null && (jsonToken = jsonParser.a()) == null) {
            throw fF.from(jsonParser, "No content to map due to end-of-input");
        }
        return jsonToken;
    }

    protected Object _unwrapAndDeserialize(JsonParser jsonParser, fA fA2, fz fz2, fC fC2, fD<Object> fD2) {
        Object object;
        String string = fz2.getRootName();
        if (string == null) {
            object = this._rootNames.findRootName(fC2, fz2);
            string = ((eH)object).getValue();
        }
        if (jsonParser.c() != JsonToken.START_OBJECT) {
            throw fF.from(jsonParser, "Current token not START_OBJECT (needed to unwrap root name '" + string + "'), but " + (Object)((Object)jsonParser.c()));
        }
        if (jsonParser.a() != JsonToken.FIELD_NAME) {
            throw fF.from(jsonParser, "Current token not FIELD_NAME (to contain expected root name '" + string + "'), but " + (Object)((Object)jsonParser.c()));
        }
        object = jsonParser.a();
        if (!string.equals(object)) {
            throw fF.from(jsonParser, "Root name '" + (String)object + "' does not match expected ('" + string + "') for type " + fC2);
        }
        jsonParser.a();
        Object object2 = fD2.deserialize(jsonParser, fA2);
        if (jsonParser.a() != JsonToken.END_OBJECT) {
            throw fF.from(jsonParser, "Current token not END_OBJECT (to match wrapper object with root name '" + string + "'), but " + (Object)((Object)jsonParser.c()));
        }
        return object2;
    }

    protected fD<Object> _findRootDeserializer(fA fA2, fC fC2) {
        fD<Object> fD2 = this._rootDeserializers.get(fC2);
        if (fD2 != null) {
            return fD2;
        }
        fD2 = fA2.findRootValueDeserializer(fC2);
        if (fD2 == null) {
            throw new fF("Can not find a deserializer for type " + fC2);
        }
        this._rootDeserializers.put(fC2, fD2);
        return fD2;
    }

    protected void _verifySchemaType(ef ef2) {
        if (ef2 != null && !this._jsonFactory.canUseSchema(ef2)) {
            throw new IllegalArgumentException("Can not use FormatSchema of type " + ef2.getClass().getName() + " for format " + this._jsonFactory.getFormatName());
        }
    }
}

